package example

import rx.lang.scala.Observable
import scala.concurrent.Future
import scala.concurrent.ExecutionContext.Implicits.global
import scala.concurrent.duration._

object FirstRxApp extends App {

  // Utworzenie pustego obiektu obserwowalnego.
  val emptyObservable = Observable.empty

  // Utworzenie obiektu obserwowalnego, który emituje tylko wartość 1.
  val numObservable = Observable.just(1)

  val sequence = List(1, 3, 5, 7, 9)

  // Utworzenie obiektu obserwowalnego, który emituje wartości z podanej sekwencji.
  val sequenceObservable = Observable.from(sequence)

  val someAsyncComputation = Future { 1 }
  // Utworzenie obiektu obserwowalnego emitującego wartości z asynchronicznie przeprowadzanej operacji.
  val fromAsyncObservable = Observable.from(someAsyncComputation)

  // Utworzenie obiektu obserwowalnego, który emituje elementy w trakcie podanego czasu.
  val intervalObservables = Observable.interval(200 millis)

  // Utworzenie obiektu obserwowalnego, który rozpoczyna emitować zdarzenia dopiero po dołączeniu obserwatora.
  val deferObservable = Observable.defer(fromAsyncObservable)
  
  // Utworzenie obiektu obserwowalnego, który nie emituje żadnej wartości.
  val neverObservable = Observable.never
}
