package example

import rx.lang.scala.Observable

object SmartApp extends App {

  val src = "/Users/vika/Documents/LSProg/LSPWorkspace/First_Proj_Rx/src/main/scala/example/football_stats.csv"

  val playerObservable =
    Observable.from(PlayerService.readPlayerDataFromSource(src))

  playerObservable
    .map(playerString =>
    PlayerService.parseToPlayer(playerString))
    .subscribe(player => PlayerService.showPlayerInformation(player),
    error => println(s"Wystąpił błąd: ${error.getMessage}"))

  Thread.sleep(10000)
}
