#!/bin/bash
#byLeal

function dohelp(){
        echo "+------------------------------------------------------+"
        echo "| Prosty skrypt do naprawy wpisów dotyczących rekordów |"
        echo "| DNS Active Directory (książka Implementing Samba 4). |"
        echo "|                                                      |"
        echo "|                       Copyright(c) 2013 Marcelo Leal |"
        echo "+------------------------------------------------------+"
        echo " Użycie:"
        echo ""
        echo " \"-h\" wyświetlenie tego komunikatu"
        echo " \"-l\" wyświetlenie rekordów DNS z pliku." 
        echo " \"-c <IP>\" sprawdzenie wpisów DNS w Samba 4."
        echo " \"-f <IP>\" naprawa wpisów DNS w Samba 4." 
        echo ""
        echo " Plik bazowy można pobrać z systemu Microsoft"
        echo " Windows Server:"
        echo " C:\Windows\System32\config\netlogon.dns"
        echo ""
        echo " Kody błędów:     (0) OK," 
        echo "                  (1) Nieprawidłowe opcje," 
        echo "                  (2) Błąd w co najmniej jednym rekordzie,"
        echo "                  (3) Nie można otworzyć pliku dns.txt."
}

function dolist(){
	while IFS=" " read a b c d e f g h
	do
		# Rekordy A...
		if [ $d == "A" ]; then
			echo "Rekord typu [  $d  ]: $a IP: $e"	
		fi
		# Rekordy SRV...
		if [ $d == "SRV" ]; then
			echo "Rekord typu [ $d ]: $a nazwa hosta: $h"	
		fi
		# Rekordy CNAME...
		if [ $d == "CNAME" ]; then
			echo "Rekord typu [$d]: $a nazwa hosta: $e"	
		fi
	done<./dns.txt
}

function docheck(){
	ipdns=$1
	while IFS=" " read a b c d e f g h
	do
		echo -n "Rekord typu [  $d  ]: $a liczba wpisów:"	
		# Rekordy A...
		if [ $d == "A" ]; then
			howmany=`host -t $d $a | wc -l`;
			if [ $howmany -eq 1 ]; then
				echo -n " $howmany [OK], zarejestrowane IP:"
				ipreg=`host -t $d $a | awk '{print $NF}'`; 
				if [ $ipreg == "$ipdns" ]; then
					echo " [OK]."
				else
					echo " $ipreg [BŁĄD!]"
				fi
			else
				echo " $howmany [BŁĄD!]"
			fi
				
		fi
		# Rekordy SRV...
		if [ $d == "SRV" ]; then
			howmany=`host -t $d $a | wc -l`;
			if [ $howmany -eq 1 ]; then
				echo -n " $howmany [OK], zarejestrowana nazwa hosta:"
				namereg=`host -t $d $a | awk '{print $NF}' | awk -F. '{print $1}'`;
				if [ $namereg == "$hostname" ]; then
					echo " [OK]."
				else
					echo " $namereg [BŁĄD!]"
				fi
			else
				echo " $howmany [BŁĄD!]"
			fi
		fi
		# Rekordy CNAME...
		if [ $d == "CNAME" ]; then
			# Rekord CNAME został usunięty w książce, aby pokazać czytelnikowi pewne przykłady...
			# echo "Rekord typu [$d]: $a nazwa hosta: $e - USUNIĘTE W KSIĄŻCE, ABY POKAZAĆ CZYTELNIKOWI PEWNE PRZYKŁADY"	
			echo ""
		fi
	done<./dns.txt
}

function dofix(){
        ipdns=$1
        while IFS=" " read a b c d e f g h
        do
		shortname=`echo $a | awk -F. '{print tolower($1)}'`;
		lastdomain=`echo $a | awk -F. '{for (i=2;i<=NF;++i) printf("%s.", $i)}' | awk '{print tolower($0)}'`;
		# Usunięcie pozostałyck kropek...
		rn=`echo $lastdomain | sed -e 's/\.*$//g' | awk '{print tolower($0)}'`;
                echo -n "Rekord typu [ $d ]: $a Liczba wpisów:"
                howmany=`host -t $d $a | wc -l`;

                if [ $howmany -eq 1 ]; then
                        echo -n " $howmany [OK], zarejestrowane:"
			if [ $d == "A" ]; then
                        	ipreg=`host -t $d $a | awk '{print $NF}'`;
                        	if [ $ipreg == "$ipdns" ]; then
                                	echo " [OK]."
                        	else
                                	echo -n " $ipreg [BŁĄD!] Naprawa...:"
                                	eval /usr/local/samba/bin/samba-tool dns update $ipdns $rn $shortname A $ipreg $ipdns --password \'$password\' >/dev/null 2>&1
                             		if [ $? -eq 0 ]; then
                                       		echo " [OK]."
                               		else
                                       		echo " [BŁĄD!]"
                               		fi
                        	fi
			fi 
			if [ $d == "SRV" ]; then
                                namereg=`host -t $d $a | awk '{print $NF}' | awk -F. '{print tolower($1)}'`;
                                if [ $namereg == "$hostname" ]; then
                                        echo " [OK]."
                                else
                                        echo -n " $namereg [BŁĄD!] Naprawa...:"
                                	eval /usr/local/samba/bin/samba-tool dns update $ipdns $rn $shortname SRV $ipreg $ipdns --password \'$password\' >/dev/null 2>&1
                             		if [ $? -eq 0 ]; then
                                       		echo " [OK]."
                               		else
                                       		echo " [BŁĄD!]"
					fi
                               	fi
                        fi

                else
                        echo -n " $howmany [BŁĄD!] Naprawa...:";
			if [ $d == "A" ]; then
				tf=$(tempfile) || exit
				control=0;
				host -t $d $a > $tf;
				while IFS=" " read w1 w2 w3 w4
				do
					sn=`echo $w1 | awk -F. '{print tolower($1)}'`;
					fullname=`echo $w1 | awk -F. '{for (i=2;i<=NF;++i) printf("%s.", $i)}' | awk '{print tolower($0)}'`;
					fn=`echo $w1 | sed -e 's/\.*$//g' | awk '{print tolower($0)}'`;
					if [ $w4 != "$ipdns" ]; then
						if [ $fn == $zone ]; then
                               				eval /usr/local/samba/bin/samba-tool dns delete $ipdns $fn @ A $w4 --password \'$password\' >/dev/null 2>&1
						else
                               				eval /usr/local/samba/bin/samba-tool dns delete $ipdns $fn $sn A $w4 --password \'$password\' >/dev/null 2>&1
						fi
                               			if [ $? -eq 0 ]; then
                                       			echo " [OK]."
                               			else
                                      			echo " [BŁĄD!]"
                               			fi
					else
						control=1;
					fi
				done<$tf
				if [ $control -eq 0 ]; then
                               		eval /usr/local/samba/bin/samba-tool dns add $ipdns $fullname @ A $w4 --password \'$password\' >/dev/null 2>&1
                               		if [ $? -eq 0 ]; then
                               			echo " [OK]."
                               		else
                               			echo " [BŁĄD!]"
                               		fi
				fi
                	fi
			if [ $d == "SRV" ]; then
				tf=$(tempfile) || exit
				control=0;
				host -t $d $a > $tf;
				while IFS=" " read y1 y2 y3 y4 y5 y6 y7 y8
				do
					sn=`echo $y1 | awk '{print tolower($0)}' | sed -e "s/\.$zone//g" | sed -e 's/\.*$//g'`;
					srvname=`echo $y8 | awk -F. '{print tolower($1)}'`;
					fullname=`echo $y8 | awk '{print tolower($0)}' | sed -e 's/\.*$//g'`;
					if [ $srvname != "$hostname" ]; then
						if [ `echo $sn | grep _msdcs` >/dev/null 2>&1 ]; then
							sns=`echo $y1 | awk '{print tolower($0)}' | sed -e "s/\._msdcs\.$zone//g" | sed -e 's/\.*$//g'`;
                               				eval /usr/local/samba/bin/samba-tool dns delete $ipdns _msdcs.$zone $sns SRV \"$fullname $y7 $y5 $y6\" --password \'$password\' >/dev/null 2>&1
						else
                               				eval /usr/local/samba/bin/samba-tool dns delete $ipdns $zone $sn SRV \"$fullname $y7 $y5 $y6\" --password \'$password\' >/dev/null 2>&1
						fi
                               			if [ $? -eq 0 ]; then
                                       			echo " [OK]."
                               			else
                                      			echo " [BŁĄD!]."
                               			fi
					else
						control=1;
					fi
				done<$tf
				if [ $control -eq 0 ]; then
					if [ $fn == $zone ]; then
                               			eval /usr/local/samba/bin/samba-tool dns add $ipdns $zone $sn SRV \"$fullname $y7 $y5 $y6\" --password \'$password\'
					else
                               			eval /usr/local/samba/bin/samba-tool dns add $ipdns $zone $sn SRV \"$fullname $y7 $y5 $y6\" --password \'$password\'
					fi
                               		if [ $? -eq 0 ]; then
                               			echo " [OK]."
                               		else
                               			echo " [BŁĄD!]."
                               		fi
				fi
                	fi
		fi

                # Rekordy CNAME...
                if [ $d == "CNAME" ]; then
			# Rekord CNAME został usunięty książkce, aby pokazać czytelnikowi pewne przykłady...
                        # echo "Rekord typu [$d]: $a Nazwa hosta: $e"
			echo ""
                fi
        done<./dns.txt
}

# Zmień na odpowiednie wartości...
#-------------------------------------
zone="poa.msdcbrz.eall.com.br";
password='w1ndow$$';
#-------------------------------------

# Gra...
hostname=`hostname | awk '{ print tolower($0)}'`;

if [ $# -eq 1 ]; then
	if [ $1 == "-h" ]; then
		dohelp;
		exit 0;
	fi
	if [ $1 == "-l" ]; then
		dolist;
		exit 0;
	fi
fi
# Czy mamy plik dns.txt?
if [ ! -f ./dns.txt ]; then
	echo "-> BŁĄD: Nie można znaleźć pliku dns.txt.";
	exit 3;
fi

# W przypadku innych opcji konieczny jest adres IP serwera Samba 4...
if [ $# -ne 2 ]; then
        dohelp;
        exit 1;
else
	if [ $1 == "-h" ] || [ $1 == "-l" ]; then
		echo "-> BŁĄD: opcje -l i -h nie wymagają żadnych innych argumentów.";
		exit 1;
	fi
	if [ $2 == "-h" ] || [ $2 == "-l" ]; then
		echo "-> BŁĄD: opcje -l i -h nie wymagają żadnych innych argumentów.";
		exit 1;
	fi
fi

case "$1" in
        -c) docheck "$2"
        ;;
        -f) dofix "$2"
        ;;
        *) dohelp; exit 1
        ;;
esac
exit 0;
