require 'test_helper'

class PhotosControllerTest < ActionController::TestCase
  fixtures :photos, :categories, :categories_photos
  
  def test_should_get_index
    get :index
    assert_response :success
    assert_not_nil assigns(:photos)
  end

  def test_should_get_new
    get :new
    assert_response :success
  end

  def test_should_create_photo
    assert_difference('Photo.count') do
      post :create, :photo => { :filename => 'testfilename.jpg' } 
    end

    assert_redirected_to photo_path(assigns(:photo))
  end

  def test_should_show_photo
    get :show, :id => photos(:photo_1).id
    assert_response :success
  end

  def test_should_get_edit
    get :edit, :id => photos(:photo_1).id
    assert_response :success
  end

  def test_should_update_photo
    put :update, :id => photos(:photo_1).id, :photo => { }
    assert_redirected_to photo_path(assigns(:photo))
  end

  def test_should_destroy_photo
    assert_difference('Photo.count', -1) do
      delete :destroy, :id => photos(:photo_1).id
    end

    assert_redirected_to photos_path
  end
  
  def test_should_gracefully_fail_and_render_new 
    Photo.any_instance.expects(:save).returns(false) 
    
    assert_no_difference 'Photo.count' do 
      post :create, :photo => { :filename => 'cat.photo' } 
      
      assert_response :success 
      assert_template 'new' 
    end 
  end 
  
  def test_should_gracefully_fail_and_render_edit 
    Photo.any_instance.expects(:update_attributes).returns(false) 
    
    put :update, :id => photos(:photo_1).id, :photo => { }      
    assert_response :success 
    assert_template 'edit' 
  end 
  
end
