class Photo < ActiveRecord::Base
  has_many :slides
  has_and_belongs_to_many :categories
  
  validates_presence_of :filename 
  
  named_scope :with_filetype_jpg, :conditions => "filename like '%.jpg'" 
  named_scope :with_thumbnail, :conditions => "thumbnail not null and thumbnail != ''"
  named_scope :with_filetype, 
    lambda {|ftype| {:conditions => ["filename like ?", "%.#{ftype}"] } } 
end
