# Skrypt 17.5 - lambdas.rb

# Metoda, ktra zwraca lambd:
def return_power_lambda(power)
  lambda { |x| x ** power }
end

# Utworzenie dwch lambd:
squared = return_power_lambda(2)
cubed = return_power_lambda(3)

# Zastosowanie lambd do pewnych liczb:
2.upto(10) do |n|
  puts "#{n} do kwadratu to #{squared.call(n)}"
  puts "#{n} do szecianu to #{cubed.call(n)}"
end