# Skrypt 11.6 - testing.rb

# Definicja klasy Rectangle:
class Rectangle

  attr_reader :height, :width

  def initialize(h = 0, w = 0)
    raise ArgumentError.new('Wysoko musi by liczb dodatni.') unless (h.is_a? Numeric) && (h > 0)
    raise ArgumentError.new('Szeroko musi by liczb dodatni.') unless (w.is_a? Numeric) && (w > 0)
    @height, @width = h, w
  end

  def perimeter
    (@height + @width) * 2
  end

  def is_square?
    if @height == @width then
      true
    else
      false
    end
  end

end # Koniec definicji klasy Rectangle.

# Doczanie biblioteki testujcej:
require 'test/unit'

# Definicja klasy testujcej:
class TestRectangle < Test::Unit::TestCase

  def test_is_square
    assert(Rectangle.new(6, 6).is_square?)
    assert(!Rectangle.new(3.58, 1234).is_square?)
  end
  
  def test_perimeter
    assert_equal(48, Rectangle.new(20, 4).perimeter)
    assert_equal(48, Rectangle.new(4, 20).perimeter)
  end
  
  def test_create_rectangle
    assert_instance_of(Rectangle, Rectangle.new(1, 2))
    assert_equal(5, Rectangle.new(5, 8).height)
    assert_equal(8, Rectangle.new(5, 8).width)
    assert_nothing_raised do 
      r = Rectangle.new(3, 4)
      puts r.height
      puts r.width
      puts r.perimeter
      puts r.is_square?
    end
    assert_raise(ArgumentError) { Rectangle.new(3) }
    assert_raise(ArgumentError) { Rectangle.new(-1, 2) }
    assert_raise(ArgumentError) { Rectangle.new('cat', 6) }
  end
  
end # Koniec definicji klasy testujcej.