# Skrypt 8.6 - creditcard2.rb

# Klasa czciowa reprezentujca karty kredytowe:
class CreditCard

  # Zmienna instancji klasy:
  @total_limit = 0

  attr_reader :balance, :limit
  protected :balance
  def initialize(limit, bal = 0)
    @limit = limit
    @balance = bal
  end
  
  # Zwracanie cakowitego limitu:
  def self.total_limit
    @total_limit
  end

  # Dodawanie do cakowitego limitu:
  def self.new(limit, bal = 0)
    @total_limit += limit
    super
  end

  def charge(amt)
    debit(amt)
  end
  def payment(amt)
    credit(amt)
  end
  def available
    @limit - @balance
  end
  def >(rh)
    return nil unless rh.respond_to?('balance')
	@balance > rh.balance
  end
  private
  def debit(amt)
    @balance += amt
  end
  def credit(amt)
    @balance -= amt
  end
end # Koniec definicji klasy CreditCard.

# Utworzenie dwch obiektw:
mc = CreditCard.new(2000)
visa = CreditCard.new(3000, 1200)

# Wywietlenie cakowitego limitu:
puts "Sumaryczny limit wszystkich kart wynosi #{CreditCard.total_limit}."

# Dodanie kolejnej karty i powtrzenie:
disc = CreditCard.new(1500)
puts "Sumaryczny limit wszystkich kart wynosi #{CreditCard.total_limit}."