# Skrypt 8.4 - creditcard.rb

# Klasa czciowa reprezentujca karty kredytowe:
class CreditCard

  # Gettery niezbdne dla zmiennych balance i limit:
  attr_reader :balance, :limit
  
  # Ochrona gettera balance:
  protected :balance

  # Konstruktor okrelajcy limit i saldo karty:
  def initialize(limit, bal = 0)
    @limit = limit
    @balance = bal	
  end

  # Obcienie karty:
  def charge(amt)
    # walidacja
    debit(amt)
  end

  # Spata karty:
  def payment(amt)
    # walidacja
    credit(amt)
  end
  
  # Zwracanie rnicy pomidzy limitem a saldem:
  def available
    @limit - @balance
  end
  
  # Porwnywanie dwch obiektw pod ktem salda:
  def >(rh)
    return nil unless rh.respond_to?('balance')
    @balance > rh.balance
  end
  
  # Metody prywatne majce wpyw na saldo karty:
  private
  def debit(amt)
    @balance += amt
  end
  def credit(amt)
    @balance -= amt
  end
	
end # Koniec definicji klasy CreditCard.

# Utworzenie dwch obiektw:
mc = CreditCard.new(2000)
visa = CreditCard.new(3000, 1200)

# Obcienie karty majcej wiksze saldo:
if mc.available > visa.available then 
  mc.charge(225)
  puts "Karta MasterCard zostaa obciona kwot 225 z!"
else 
  visa.charge(225) 
  puts "Karta Visa zostaa obciona kwot 225 z!"
end

# Spata zaduenia karty o najwyszym saldzie:
if mc > visa then 
  mc.payment(500)
  puts "Spata w wysokoci 500 z zostaa wysana do firmy MasterCard!"
else 
  visa.payment(500) 
  puts "Spata w wysokoci 500 z zostaa wysana do firmy Visa!"
end