# Skrypt 11.4 - circle.rb

# Definicja klasy Circle:
class Circle

  # Doczanie klasy mieszanej Comparable:
  include Comparable
  
  # Akcesory dla promienia koa:
  attr_reader :radius
  
  # Konstruktor przypisuje warto promieniowi:
  def initialize(r = '')
    
    # Promie musi by liczb dodatni:
    raise ArgumentError.new('Promie musi by liczb dodatni.') unless (r.is_a? Numeric) && (r > 0)
    
    @radius = r
  end
  
  # Definicja oglnego operatora porwnania:
  def <=>(rh)
  raise TypeError.new('Oba obiekty musz by typu Circle.') unless rh.is_a? Circle
    @radius <=> rh.radius
  end

end # Koniec definicji klasy Circle