# Niniejszy modu ma za zadanie przechowywa informacje o stanie globalnym, dziki czemu
# nie ma potrzeby modyfikowa globalnej przestrzeni nazw wicej ni jest to konieczne.
module ClassTrace
  # Niniejsza tablica przechowuje list zaadowanych plikw i zdefiniowanych klas.
  # Kady element jest podtablic zawierajc zdefiniowan klas lub
  # zaadowany plik oraz ramk stosu, na ktrym klas t zdefiniowano lub zaadowano plik.
  T = []  # Tablica przechowujca zaadowane pliki.
  # Teraz zostanie zdefiniowana staa OUT okrelajca, gdzie maj zosta wysane dane ze ledzenia.
  # Domylnie jest to strumie STDERR, ale mona to zmieni za pomoc argumentw wiersza polece.
  if x = ARGV.index("--traceout")    # Jeli argument istnieje,
    OUT = File.open(ARGV[x+1], "w")  # zostaje otwarty wyznaczony plik,
    ARGV[x,2] = nil                  # a argumenty zostaj usunite.
  else
    OUT = STDERR                     # W przeciwnym przypadku stosowana jest warto domylna.
  end
end
# Tworzenie acucha aliasw  krok 1.: definicja aliasw dla oryginalnych metod.
alias original_require require
alias original_load load
# Tworzenie acucha aliasw  krok 2.: definicja nowych wersji tych metod.
def require(file)
  ClassTrace::T << [file,caller[0]]     # Zapamituje, co zostao gdzie zaadowane.
  original_require(file)                # Wywoanie oryginalnej metody.
end
def load(*args)
  ClassTrace::T << [args[0],caller[0]]  # Zapamitanie, co zostao gdzie zaadowane.
  original_load(*args)                  # Wywoanie oryginalnej metody.
end
# Niniejsza metoda zwrotna jest wywoywana w odpowiedzi na definicj kadej klasy.
def Object.inherited(c)
  ClassTrace::T << [c,caller[0]]        # Zapamitanie, co zostao gdzie zdefiniowane.
end
# Metoda Kernel.at_exit rejestruje blok, ktry ma by wykonywany przed zamkniciem programu.
# Za jej pomoc program raportuje zebrane informacje o plikach i klasach.
at_exit {
  o = ClassTrace::OUT
  o.puts "="*60
  o.puts "Zaadowane pliki i zdefiniowane klasy:"
  o.puts "="*60
  ClassTrace::T.each do |what,where|
    if what.is_a? Class  # Raport o zdefiniowanej klasie (z hierarchi).
      o.puts "Zdefiniowano: #{what.ancestors.join('<-')} w #{where}"
    else                 # Raport o zaadowanym pliku.
      o.puts "Zaadowano: #{what} w #{where}"
    end
  end
}
