class Module
  # Niniejsza metoda definiuje metody odczytu i zapisu atrybutw dla wyznaczonych
  # atrybutw, ale przyjmuje jako argument tablic asocjacyjn rzutujc nazwy atrybutw
  # na ich wartoci domylne. Wygenerowane w ten sposb metody odczytu atrybutw zwracaj
  # swoje wartoci domylne, jeli zmienna egzemplarza nie jest jeszcze zdefiniowana.
  def attributes(hash)
    hash.each_pair do |symbol, default|   # Dla kadej pary atrybut/warto domylna.
      getter = symbol                     # Nazwa metody sprawdzajcej.
      setter = :"#{symbol}="              # Nazwa metody ustawiajcej.
      variable = :"@#{symbol}"            # Nazwa zmiennej egzemplarza.
      define_method getter do             # Definicja metody sprawdzajcej.
        if instance_variable_defined? variable
          instance_variable_get variable  # Zwraca zmienn, jeli jest zdefiniowana.
        else
          default                         # W przeciwnym przypadku zwraca warto domyln.
        end
      end
      define_method setter do |value|     # Definicja metody ustawiajcej.
        instance_variable_set variable,   # Ustawienie zmiennej egzemplarza
                              value       # na warto argumentu.
      end
    end
  end
  # Metoda ta dziaa jak metoda attributes, ale definiuje metody klasowe,
  # wywoujc metod attributes na rzecz klasy eigenclass zamiast self.
  # Zdefiniowane metody uywaj zmiennych egzemplarza klasy
  # zamiast zwykych zmiennych klasowych.
  def class_attrs(hash)
    eigenclass = class << self; self; end
    eigenclass.class_eval { attributes(hash) }
  end
  # Obie metody s prywatne.
  private :attributes, :class_attrs
end
