# Pozyskanie muteksu zwizanego z obiektem o i wykonanie
# bloku pod ochron tego muteksu.
# Dziaa podobnie do sowa kluczowego Javy synchronized.
def synchronized(o)
  o.mutex.synchronize { yield }
end
# Metoda Object.mutex nie istnieje, a wic trzeba j zdefiniowa.
# Metoda ta zwraca unikatowy muteks dla kadego obiektu i dla poszczeglnych
# obiektw zwraca zawsze ten sam muteks.
# Muteksy s tworzone leniwie, co wymaga synchronizacji ze wzgldu na
# bezpieczestwo wtkw.
class Object
  # Metoda ta zwraca muteks dla tego obiektu, tworzc go w razie potrzeby.
  # Sztuka polega na tym, aby dwa rne wtki nie wywoay
  # jej jendoczenie, tworzc dwa rne muteksy.
  def mutex
    # Jeli ten obiekt posiada ju muteks, zostanie on zwrcony.
    return @__mutex if @__mutex

    # W przeciwnym przypadku konieczne jest utworzenie muteksu dla tego obiektu.
    # Aby byo bezpiecznie, konieczna jest synchronizacja naszego obiektu klasy.
    synchronized(self.class) {
      # Ponowne sprawdzenie: od czasu wejcia do tego synchronizowanego bloku
      # jaki inny wtek mg ju utworzy ten muteks.
      @__mutex = @__mutex || Mutex.new
    }
    # Wartoci zwrotn jest @__mutex.
  end
end
# Zdefiniowana powyej metoda Object.mutex musi zablokowa klas, jeli
# obiekt nie ma jeszcze muteksu. Jeli klasa nie posiada jeszcze wasnego muteksu,
# obiekt tej klasy zostanie zablokowany. Aby zapobiec nieskoczonej rekurencji,
# musisz upewni si, e obiekt ten ma muteks.
Class.instance_eval { @__mutex = Mutex.new }
