# Wywoanie metody each po kolei w kadej z kolekcji.
# Nie jest to iteracja rwnolega, a wic nie jest wymagany enumerator.
def sequence(*enumerables, &block)
  enumerables.each do |enumerable|
    enumerable.each(&block)
  end
end
# Iteracja przez podane kolekcje z przeplataniem ich elementw.
# Nie mona tego zrobi szybko bez uycia iteratorw zewntrznych.
# Warto zauway rzadki przypadek uycia klauzuli else w bloku begin-rescue.
def interleave(*enumerables)
  # Konwersja przeliczalnych kolekcji na tablic enumeratorw.
  enumerators = enumerables.map {|e| e.to_enum }
  # Ptla dziaa tak dugo, a wyczerpi si enumeratory.
  until enumerators.empty?
    begin
      e = enumerators.shift   # Pobranie pierwszego enumeratora.
      yield e.next            # Pobranie kolejnego elementu i przekazanie go do bloku.
    rescue StopIteration      # Jeli nie ma wicej elementw, nic si nie dzieje.
    else                      # Jeli nie wystpi aden wyjtek,
      enumerators << e        # enumerator zostaje zwrcony z powrotem.
    end
  end
end
# Iteracja przez okrelone kolekcje ze zwrotem krotek wartoci,
# po jednej wartoci z kadej kolekcji. Zobacz te Enumerable.zip.
def bundle(*enumerables)
  enumerators = enumerables.map {|e| e.to_enum }
  loop { yield enumerators.map {|e| e.next} }
end
# Przykady dziaania powyszych metod iteracyjnych.
a,b,c = [1,2,3], 4..6, 'a'..'e'
sequence(a,b,c) {|x| print x}   # Drukuje "123456abcde".
interleave(a,b,c) {|x| print x} # Drukuje "14a25b36cde".
bundle(a,b,c) {|x| print x}     # '[1, 4, "a"][2, 5, "b"][3, 6, "c"]'.
