module PlayingCards
  RANKS = %w{ 2 3 4 5 6 7 8 9 10 J Q K A }
  SUITS = %w{ trefle kara kiery piki }
  class Deck
    def initialize                         #1
      @cards = []
      RANKS.each do |r|
        SUITS.each do |s|
          @cards << "#{r} of #{s}"
        end
      end
      @cards.shuffle!
    end

    def deal(n=1)
      n.times.map { @cards.pop }           #2
    end

    def size                               #3
      @cards.size
    end
  end
end
