# TEN SKRYPT MA BYĆ URUCHAMIANY W JUPYTER NOTEBOOK (UŻYŁEM VS CODE)

# %%
import numpy as np
import pandas as pd
from sklearn.model_selection import train_test_split
from pycaret.classification import *

# %%
# Odkomentuj ten kod, jeśli nie używasz go w Power BI
# w celu załadowania imputowanego zbioru danych testowych o katastrofie Titanica
# dataset = pd.read_csv(r'c:\Users\User\Desktop\Extending Power BI\kod\Extending-Power-BI-with-Python-and-R-main\Chapter13\titanic-imputed.csv')
# dataset

# %%
# Podzielmy ramkę danych na niewielką część, która ma być przechowywana do celów testowych i
# dużą część do celów szkolenia modelu.
X = dataset.drop('Survived',axis=1)
y = dataset[['Survived']]

X_train,X_test,y_train,y_test=train_test_split(X,y,test_size=0.05)

# %%
# Scalanie ramki danych szkoleniowych cechy i docelowej kolumny szkoleniowej w unikatową ramkę danych szkoleniowych 
df_training = pd.concat([X_train, y_train], axis=1, ignore_index=True).reset_index(drop=True, inplace=False)
# Utworzenie tablicy łączącej nazwy kolumn cech i zmiennej docelowej
col_names = np.concatenate((X.columns, y.columns),axis=0)
# Przypisanie nazw kolumn do nowej ramki danych
df_training = df_training.set_axis(col_names,axis=1)

# %%
# Wymuszenie konwersji zmiennoprzecinkowej wartości float kolumny Pclass na liczbę całkowitą, ponieważ usługa Power BI importuje ją jako kolumnę int
df_training['Pclass'] = df_training['Pclass'].astype('int')

# %%
# Skonfiguruj poprawnie eksperyment PyCaret AutoML
exp_clf = setup(data = df_training, target = 'Survived', session_id=5614,
                categorical_features=['Sex','Embarked'],
                ordinal_features={'Pclass' : [1,2,3]},
                n_jobs=1, # wyeliminowanie równoległości w celu umożliwienia działania w usłudze Power BI
                silent=True,
                verbose=False)

# %%
# Uzyskaj model, który działa lepiej w fazie walidacji krzyżowej.
# Użyj parametru verbose=True, aby uzyskać wszystkie metryki jako wyniki w programie VS Code.
best_model = compare_models(verbose=True)

# %%
# Zapisz model w pliku pkl w celu ponownego użycia w przyszłości
save_model(best_model, r'c:\Users\User\Desktop\Extending Power BI\kod\Extending-Power-BI-with-Python-and-R-main\Chapter13\Python\titanic-model')

# %%
# Scalanie ramki danych szkoleniowych cechy i docelowej kolumny szkoleniowej w unikatową ramkę danych szkoleniowych
# i zapisanie jej w pliku CSV do ponownego wykorzystania w przyszłości
df_test = pd.concat([X_test, y_test], axis=1, ignore_index=True).reset_index(drop=True, inplace=False)
df_test = df_training.set_axis(col_names,axis=1)
# %%
df_test.to_csv(r'c:\Users\User\Desktop\Extending Power BI\kod\Extending-Power-BI-with-Python-and-R-main\Chapter13\titanic-test.csv',
               index=False)

# %%
# Uzyskaj prognozy modelu dla wejściowej ramki danych
predictions = predict_model(best_model,data = df_test,verbose=False)
predictions
