library(readr)
library(namedCapture)


access_log_lines <- read_lines('C:\\Users\\User\\Desktop\\Extending Power BI\\kod\\Extending-Power-BI-with-Python-and-R-main\\Chapter05\\loading-complex-log-files-using-regex\\apache_logs.txt')


# Zdefiniuj regex dla informacji (zmiennych) zawartych w każdym wierszu logu
regex_parts <- c(
    r'{(?P<hostName>\S+)}'                              # nazwa zdalnego hosta (adres IP)
  , r'{\S+}'                                             # zdalna nazwa loga (myślnik, jeśli jest pusty; nie jest używany w przykładowym pliku)
  , r'{(?P<userName>\S+)}',                               # użytkownik zdalny, jeśli żądanie zostało uwierzytelnione (myślnik jeśli jest pusty)
  , r'{\[(?P<requestDateTime>[\w:/]+\s[+\-]\d{4})\]}',    # datetime reprezentujący datę otrzymania żądania w formacie [18/Sep/2011:19:18:28 -0400]
  , r'{"(?P<requestContent>\S+\s?\S+?\s?\S+?)"}'        # pierwszy wiersz żądania wysłanego do serwera między podwójnymi cudzysłowami "%r"
  , r'{(?P<requestStatus>\d{3}|-)}'                     # Kod stanu HTTP dla żądania
  , r'{(?P<responseSizeBytes>\d+|-)}'                   # rozmiar odpowiedzi w bajtach, z wyłączeniem nagłówków HTTP (może być '-')
  , r'{"(?P<requestReferrer>[^"]*)"}',                    # Nagłówek żądania HTTP Referer, który zawiera bezwzględny lub częściowy adres strony wysyłającej żądanie
  , r'{"(?P<requestAgent>[^"]*)?"}'                     # Nagłówek żądania HTTP User-Agent, który zawiera ciąg identyfikujący aplikację, system operacyjny, dostawcę i(lub) wersję żądającego klienta użytkownika
)

# Połącz wszystkie części regex za pomocą '\s+' jako separatora i
# dodaj '$' na końcu
pattern <- paste0( paste(regex_parts, collapse = r'{\s+}'), '$' )

df <- as.data.frame( str_match_named( access_log_lines, pattern = pattern ) )
