
# Funkcja serializująca dowolny obiekt do surowego wektora (bajty).
# Następnie przekształca bajty w ciąg bajtów.
to_string_of_bytes = function(x) {
  paste(as.character(serialize(x, connection = NULL)), collapse = " ")
}

# Funkcja, która tnie ciąg 's' i tworzy z niego wektor o stałej szerokości złożony ze znaków.
str_dice <- function(s, width) {
  substring(
    s,
    seq(1, nchar(s), width),
    seq(width, nchar(s) + ifelse(nchar(s) %% width > 0, width-1, 0), width)
  )
}


serializeModelsToStringDataframe <- function(models_lst) {
  
  # Zastosuj do każdego elementu listy wykresów funkcję to_string_of_bytes.
  # W wyniku otrzymasz listę zserializowanych wykresów w postaci ciągu bajtów.
  models_str_lst <- lapply(models_lst, to_string_of_bytes)
  
  # Podziel każdy ciąg bajtów na fragmenty po 10 000, aby uniknąć ograniczeń długości ciągu w wizualizacji języka R
  models_str_vec_lst <- lapply(models_str_lst, str_dice, width = 10000)
  
  
  # Utwórz pustą ramkę danych
  models_df <- data.frame()
  
  # Dla każdego identyfikatora modelu na liście złożonej z ciągów bajtów...
  for (model_id in names(models_str_vec_lst)) {
    
    # ...wyodrębnij listę fragmentów
    model_vec = models_str_vec_lst[[model_id]]
    
    # i wypełnij ją tymczasową ramką danych
    tmp_df <- data.frame(
      model_id = rep(model_id, length(model_vec)),
      chunk_id = seq(1,length(model_vec),1),
      model_str = model_vec,
      
      stringsAsFactors = FALSE
    )
    
    # Następnie dołącz tymczasową ramkę danych
    # do ramki głównej (rbind = rows bind)
    models_df <- rbind(models_df, tmp_df)
    
  }
  
  models_ids_df <- data.frame( model_id = names(models_lst) )
  
  return(
    list(
      model_ids_df = models_ids_df,
      models_df = models_df
    )
  )
  
}




project_folder <- r'{C:\<twoja-ścieżka>\Chapter13\}'

# W tym przypadku mamy tylko jeden model. Więc zdeserializujemy go jako model_01.
# Następnie stworzymy nazwaną listę zawierającą modele (w tym przypadku tylko jeden).
model_01 <- readRDS(file.path(project_folder, r'{R\titanic-model.RDS}'))

models_lst <- list('model01' = model_01)


str_models_lst <- serializeModelsToStringDataframe(models_lst)

model_ids_df <- str_models_lst[['model_ids_df']]
models_df <- str_models_lst[['models_df']]

