library(dplyr)
library(stringr)

# Możesz wybrać format dat dla danych w Twoim zestawie danych.
# 
# Możliwe opcje to: 'dd-mm-yyyy', 'mm-dd-yyyy' oraz 'yyyy-mm-dd'.
# 
# Wszystkie wyrażenia regularne działają dla wszystkich ich wariantów (na przykład 7-6-2021),
# oraz zarówno dla separatorów '-', jak i '/'.
date_format <- 'mm-dd-yyyy'

if (date_format == 'dd-mm-yyyy') {
  regex_dates_having_day_31 <- r'((?:31[\-\/](?:(?:0?[13578])|(1[02]))[\-\/](19|20)?\d\d))'
  regex_non_leap_dates_having_days_29_30 <- r'((?:(?:29|30)[\-\/](?:(?:0?[13-9])|(?:1[0-2]))[\-\/](?:19|20)?\d\d))'
  regex_leap_dates_having_day_29 <- r'((?:29[\-\/]0?2[\-\/](?:19|20)?(?:(?:[02468][048])|(?:[13579][26]))))'
  regex_remaining_dates <- r'((?:(?:(?:1\d)|(?:0?[1-9])|(?:2[0-8]))[\-\/](?:(?:0?[1-9])|(?:1[0-2]))[\-\/](?:19|20)?\d\d))'
} else if (date_format == 'mm-dd-yyyy') {
  regex_dates_having_day_31 <- r'((?:(?:(?:0?[13578])|(?:1[02]))[\-\/]31[\-\/](?:19|20)?\d\d))'
  regex_non_leap_dates_having_days_29_30 <- r'((?:(?:(?:0?[13-9])|(?:1[0-2]))[\-\/](?:29|30)[\-\/](?:19|20)?\d\d))'
  regex_leap_dates_having_day_29 <- r'((?:0?2[\-\/]29[\-\/](?:19|20)?(?:(?:[02468][048])|(?:[13579][26]))))'
  regex_remaining_dates <- r'((?:(?:(?:0?[1-9])|(?:1[0-2]))[\-\/](?:(?:1\d)|(?:0?[1-9])|(?:2[0-8]))[\-\/](?:19|20)?\d\d))'
} else if (date_format == 'yyyy-mm-dd') {
  regex_dates_having_day_31 <- r'((?:(19|20)?\d\d[\-\/](?:(?:0?[13578])|(1[02]))[\-\/]31))'
  regex_non_leap_dates_having_days_29_30 <- r'((?:(?:(?:19|20)?\d\d)[\-\/](?:(?:0?[13-9])|(?:1[0-2]))[\-\/](?:29|30)))'
  regex_leap_dates_having_day_29 <- r'((?:(?:19|20)?(?:(?:[02468][048])|(?:[13579][26]))[\-\/]0?2[\-\/]29))'
  regex_remaining_dates <- r'((?:(?:(?:19|20)?\d\d)[\-\/](?:(?:0?[1-9])|(?:1[0-2]))[\-\/](?:(?:1\d)|(?:0?[1-9])|(?:2[0-8]))))'
} else {
  stop("Nieprawidłowy format daty podany w zmiennej data_format") # w takim przypadku usługa Power BI nie wyświetli żadnego zestawu danych w następnym kroku
}

pattern <- str_glue(
  '^(?:{regex_dates_having_day_31}|{regex_non_leap_dates_having_days_29_30}|{regex_leap_dates_having_day_29}|{regex_remaining_dates})$'
)

df <- dataset %>% 
  mutate( isDateValidFromRegex = as.integer(str_detect(BannedDate, pattern)) )
