import os
import pandas as pd
import pickle
import matplotlib.pyplot as plt

# Załaduj dane do ramki danych
project_folder = "C:\\Users\\User\\Desktop\\Extending Power BI\\kod\\Extending-Power-BI-with-Python-and-R-main\\Chapter04\\importing-pkl-files"
population_df = pd.read_csv(os.path.join(project_folder, "population.csv"))

# Zdefiniuj listę wybranych krajów
selected_countries = ["Włochy", "Szwecja", "Francja", "Niemcy"]

# Stwórzmy ramkę danych zawierającą tylko wiersze odpowiadające wybranym krajom.
# Metoda isin() pomada wybrać wiersze zawierające określone wartości w danej kolumnie (jedną lub kilka)
selected_population_df = population_df.loc[ population_df['country'].isin(selected_countries) ]

# Zdefiniuj pusty słownik
nested_population_dict = {}

# Dla każdego kraju...
for c in selected_countries:

    # ... organizuj dane z kolumn 'year' i 'population' w ramce danych i
    # wstaw do słownika na pozycji odpowiadającej nazwie kraju
    nested_population_dict[c] = selected_population_df.loc[ population_df['country'] == c ].filter(['year', 'population']).reset_index(drop=True)

# Spróbujmy wykreślić szeregi czasowe dla Szwecji
selected_country = "Szwecja"
x = nested_population_dict[selected_country].year
y = nested_population_dict[selected_country].population

# Utwórz obiekt wykresu
fig_handle = plt.figure()
# Wykreśl prostą linię dla każdego punktu (x,y)
plt.plot(x, y)
# Dodaj tytuł do wykresu
plt.title("Globalna populacja kraju: " + selected_country)

# Wyświetl wykres
fig_handle.show()


# Zdefiniuj inny pusty słownik, który będzie zawierał obrazy dla każdego kraju
nested_population_plots_dict = {}

# Dla każdego kraju...
for c in selected_countries:
    
    # ...pobierz ramki danych szeregów czasowych przy użyciu poprzedniego słownika
    tmp_df = nested_population_dict[c]
    
    # Przygotuj wykres
    x = tmp_df.year
    y = tmp_df.population
    
    fig_handle = plt.figure()
    plt.plot(x, y)
    plt.title("Globalna populacja kraju " + c)

    # Dodaj do nowego słownika wykres połączony z nazwą kraju
    nested_population_plots_dict[c] = fig_handle

# Zserializuj cały słownik wykresów i zapisz go na dysk
pickle.dump( nested_population_plots_dict, open(os.path.join(project_folder, "nested_population_plots_dict.pkl"), "wb"))
