import pandas as pd
from azure.ai.textanalytics import TextAnalyticsClient
from azure.core.credentials import AzureKeyCredential


def authenticate_client():
    ta_credential = AzureKeyCredential(key)
    text_analytics_client = TextAnalyticsClient(
            endpoint=endpoint, 
            credential=ta_credential)
    return text_analytics_client


def sentimentOfColumn(df,col_name):
    
    client = authenticate_client()

    all_documents = df[col_name].tolist()

    # Grupuj wszystkie dokumenty w grupy po N.
    # N wynosi 10, ponieważ maksymalna liczba dokumentów dozwolonych jednorazowo dla bezpłatnego konta wynosi 10
    N = 10
    grouped_docs_list = [all_documents[n:n+N] for n in range(0, len(all_documents), N)]

    # Dla każdej grupy dokumentów (np. komentarzy) skorzystaj z interfejsu API analizy tekstu,
    # aby uzyskać analizę wydźwięku każdego komentarza (który może się składać z większej liczby zdań).
    sentiment_df_lst = []

    for docs_group in grouped_docs_list:
        for doc_idx, _ in enumerate(docs_group):
            response = client.analyze_sentiment(documents=docs_group)[doc_idx]

            tmp_data = [{
                'comment_sentiment': format(response.sentiment),
                'overall_positive_score': response.confidence_scores.positive,
                'overall_neutral_score': response.confidence_scores.neutral,
                'overall_negative_score': response.confidence_scores.negative
            }]
            #print(tmp_data)
            tmp_df = pd.DataFrame.from_records(tmp_data)

            # dołącz tymczasową ramkę danych do listy ramek danych sentiment_df_lst
            sentiment_df_lst.append(tmp_df)

    # Scal wszystkie ramki danych sentiment_df_lst danych w ramkę danych sentiment_df
    sentiment_df = pd.concat(sentiment_df_lst, ignore_index=True)
    
    return pd.concat([df,sentiment_df],axis=1)


# Odkomentuj to, jeśli nie używasz w Power BI
# dataset = pd.read_csv(r'C:\<twoja-ścieżka>\Chapter13\FabrikamComments.csv')
# dataset

endpoint = "<your-text-analytics-url>"
# Ze względów bezpieczeństwa możesz ustawić klucz w zmiennej środowiskowej
# i pobrać go stamtąd w tym skrypcie. Dla uproszczenia zdefiniowałem go tutaj bezpośrednio.
key = "<twój-klucz-api-analytics>"


sentiment_enriched_df = sentimentOfColumn(dataset, col_name='comment')
sentiment_enriched_df


