
library(readr)
library(readxl)
library(dplyr)
library(purrr)
library(geosphere)


airportLongLatVec <- function(df, iata) {
    ret_vec <- df %>% 
        filter( iata_code == iata ) %>% 
        select( longitude, latitude ) %>% 
        unlist()    
    
    return(ret_vec)
}


hotels_tbl <- read_xlsx(r'{D:\<twoja-ścieżka>\Chapter10\hotels-ny.xlsx}')
hotels_tbl

airports_tbl <- read_csv(r'{D:\<twoja-ścieżka>\Chapter10\airport-codes.csv}')
airports_tbl

# Współrzędne są zapisywane jako ciąg znaków, więc trzeba podzielić je na dwie nowe kolumny
airports_tbl <- airports_tbl %>% 
    tidyr::separate(
        col = coordinates,
        into = c('longitude', 'latitude'),
        sep = ', ',
        remove = TRUE,
        convert = TRUE )
airports_tbl


jfk_coordinates <- airportLongLatVec(airports_tbl, 'JFK')
lga_coordinates <- airportLongLatVec(airports_tbl, 'LGA')


# Użycie średniego (sferycznego) promienia ziemi R1 (w metrach)
# jako domyślnej wartości w pakiecie Pythona PyGeodesy
# (patrz: https://en.wikipedia.org/wiki/Earth_radius#Published_values)
hotels_tbl <- hotels_tbl %>% 
    mutate(
        p1 = map2(longitude, latitude, ~ c(.x, .y))
    ) %>% 
    mutate(
        haversineDistanceFromJFK = map_dbl(p1, ~ distHaversine(p1 = .x, p2 = jfk_coordinates, r = 6371008.771415)),
        karneyDistanceFromJFK = map_dbl(p1, ~ distGeo(p1 = .x, p2 = jfk_coordinates)),
        haversineDistanceFromLGA = map_dbl(p1, ~ distHaversine(p1 = .x, p2 = lga_coordinates, r = 6371008.771415)),
        karneyDistanceFromLGA = map_dbl(p1, ~ distGeo(p1 = .x, p2 = lga_coordinates))
    ) %>%
    select( -p1 )

hotels_tbl
