
library(tidyverse)

deserialized_tbl <- readRDS("nested_population_tbl.RDS")

# Rzućmy okiem na zdeserializowany obiekt tibble
deserialized_tbl


# Zróbmy przykład wyodrębniania danych demograficznych
# z obiektu tibble z danymi dla regionu (Szwecja)
sweden_population_tbl <- deserialized_tbl %>% 
  
  # Pobierz wiersz powiązany z krajem "Szwecja"
  filter( country == "Szwecja" ) %>% 
  
  # Pobierz zawartość 'demographic_data' dla
  # tego wiersza. Zauważ, że to jest lista
  pull( demographic_data ) %>%
  
  # Wyodrębnij tibble "demographic_data" z
  # listy (złożonej tylko z 1 elementu)
  pluck(1)

sweden_population_tbl

