import pickle
import re
import os
import pandas as pd


def serialize(obj):
    return obj.encode('latin1')

def unserialize(obj):
    return obj.decode('latin1')

def toPickle(obj):
    return pickle.dumps(obj, 0)

def toUnpickle(obj):
    return pickle.loads(obj)

def toCut(obj, width):
    return re.findall('.{1,%s}' % width, obj, flags=re.S)

def toUncut(obj):
    return "".join(obj)



project_folder = "D:\\<folder>\\<twojego>\\<projektu>"

plots_dict = pickle.load(open(os.path.join(project_folder, "nested_population_plots_dict.pkl"),"rb"))

pickled_plots_dict = {}
for country in plots_dict:
    # każdy rysunek zserializowany do Bytearray
    pickled_plots_dict[country] = toPickle(plots_dict[country])

pickled_plots_int_array_dict = {}
for country in pickled_plots_dict:
    # każda struktura Bytearray przekształcona do postaci słownika tablic int
    pickled_plots_int_array_dict[country] = [x for x in pickled_plots_dict[country]]

pickled_plots_int_str_dict = {}
for country in pickled_plots_int_array_dict:
    # każda tablica int przekształcona na ciąg znaków reprezentujący tablicę int (spacja jako separator liczb całkowitych)
    pickled_plots_int_str_dict[country] = " ".join( [str(a) for a in pickled_plots_int_array_dict[country]] )

pickled_plots_int_str_chopped_dict = {}
for country in pickled_plots_int_str_dict:
    # każdy ciąg liczb całkowitych przekształcony na listę fragmentów ciągów o szerokości 32000 (ograniczenie Python Visual: 32766)
    pickled_plots_int_str_chopped_dict[country] = toCut(pickled_plots_int_str_dict[country], width=32000)


plots_df_lst = []

# Dla każdej nazwy kraju zaczerpniętej ze słownika pickled_plots_int_str_chopped_dict...
for country in pickled_plots_int_str_chopped_dict:

    # ...pobierz listę fragmentów dla bieżącego kraju
    chops_lst = pickled_plots_int_str_chopped_dict[country]
    # pobierz liczbę fragmentów zawartych na liście
    num_chops = len(chops_lst)

    # utwórz tymczasową ramkę danych zawierającą nazwę kraju, całkowitoliczbowy indeks
    # zliczanie fragmentów i zawartości listy ciągów fragmentów
    tmp_data = {
        'country_name': [country] * num_chops,
        'chunk_id': list(range(1, num_chops+1)),
        'plot_str': chops_lst
    }

    tmp_df = pd.DataFrame(tmp_data, columns = ['country_name','chunk_id','plot_str'])

    # dołącz tymczasową ramkę danych do listy ramek danych plots_df_lst
    plots_df_lst.append(tmp_df)

# Scal wszystkie ramki danych plots_df_lst w ramkę danych plots_df
plots_df = pd.concat(plots_df_lst, ignore_index=True)

# Utwórz również ramkę danych nazw krajów
selected_countries_df = pd.DataFrame( pickled_plots_int_str_chopped_dict.keys(), columns = ['country_name'])

