# 	Extending Power BI with Python and R

<a href="https://www.packtpub.com/product/extending-power-bi-with-python-and-r/9781801078207"><img src="https://static.packt-cdn.com/products/9781801078207/cover/smaller" alt="Extending Power BI with Python and R" height="256px" align="right"></a>

To jest repozytorium kodu dla książki [Extending Power BI with Python and R](https://www.packtpub.com/product/extending-power-bi-with-python-and-r/9781801078207), wydanej  przez Packt .

**Pozyskuj, przekształcaj, wzbogacaj i wizualizuj dane przy użyciu technologii języków analitycznych**

## O czym jest ta książka?

Języki Python i R umożliwiają rozszerzanie możliwości usługi Power BI, co pozwala uprościć działania związane z pozyskiwaniem i przekształcaniem danych, ulepszaniem pulpitów nawigacyjnych i wyróżnianiem szczegółowych informacji. Dzięki wiedzy zdobytej w tej książce i zastosowaniu języków analitycznych Twoje artefakty staną się bogatsze i znacznie bardziej interesujące.

Zaczniesz od nauczenia się, jak skonfigurować środowisko usługi Power BI w celu korzystania ze skryptów w językach Python i R.  Następnie zapoznasz się z rozszerzeniami do pozyskiwania i przekształcania danych oraz zagadnieniami uzupełniania danych i ich wizualizacji. Dowiesz się, jak importować dane z nieobsługiwanych obiektów oraz jak je przekształcać za pomocą wyrażeń regularnych i złożonych algorytmów. Książka ułatwia implementację metod deidentyfikacji danych osobowych w usłudze Power BI, takich jak pseudonimizacja i anonimizacja.  Nauczysz się wywoływać zewnętrzne interfejsy API, co pozwoli wzbogacić Twoje dane za pomocą języków Python i R. Następnie zapoznasz się z zaawansowanymi technikami bazującymi na językach Python lub R, w celu przeprowadzenia dogłębnych analiz i wyodrębnienia cennych informacji za pomocą narzędzi statystyki i uczenia maszynowego. Dzięki tworzeniu wizualnych wykresów w procesie zapoznawania się z relacjami między zmiennymi w danych, lektura tej książki pozwoli Ci zrozumieć główne funkcje statystyczne wykorzystywane dla zbiorów danych.

Po zakończeniu lektury tej książki będziesz potrafił wzbogacić swój model danych i wizualizacje Power BI przy użyciu złożonych algorytmów w językach Python i R.

Dzięki tej książce poznasz następujące zagadnienia: 
* Najlepsze rozwiązania związane ze stosowaniem języków Python i R w produktach usługi Power BI.
* Wykorzystanie języków Python i R do wykonywania złożonych przekształceń danych w usłudze Power BI.
* 1.	Stosowanie anonimizacji i pseudonimizacji danych w usłudze Power BI.
* Zapisywanie danych i ładowanie dużych zestawów danych przy użyciu języków Python i R w usłudze Power BI.
* Wzbogacanie pulpitów nawigacyjnych usługi Power BI przy użyciu zewnętrznych interfejsów API i modeli uczenia maszynowego.
* Dodawanie szczegółowych informacji do danych dzięki wykorzystaniu optymalizacji liniowej i innych algorytmów.
* Obsługa wartości odstających i brakujących dla danych wielowymiarowych i szeregów czasowych.
* Tworzenie za pomocą skryptów języka R dowolnie złożonych wizualizacji.

Jeśli uważasz, że ta książka jest dla Ciebie, zdobądź [kopię](https://www.amazon.com/Extending-Power-Python-transform-analytical-ebook/dp/B09CQ5G53Y/ref=sr_1_1?crid=23ZIHDLXFV8KJ&dchild=1&keywords=extending+power+bi+with+python+and+r&qid=1635751617&sprefix=Extending+Power%2Caps%2C363&sr=8-1) today!

<a href="https://www.packtpub.com/product/extending-power-bi-with-python-and-r/9781801078207"><img src="https://raw.githubusercontent.com/PacktPublishing/GitHub/master/GitHub.png" alt="https://www.packtpub.com/" border="5" /></a>

## Instrukcje i korzystanie z kodu
Cały kod jest zorganizowany w folderach.

Kod będzie wyglądał następująco:

```
tbl <- src_tbl %>%
  mutate(
    across(categorical_vars, as.factor),
    across(integer_vars, as.integer)
  ) %>%
  select( -all_of(vars_to_drop) )
  
```
**Oto, czego potrzebujesz do studiowania materiału w tej książce:**
Ta książka jest przeznaczona dla analityków biznesowych, specjalistów ds. analizy biznesowej i analityków danych, którzy już korzystają z usługi Microsoft Power BI i dzięki zastosowaniu języków Python i R chcą dodać więcej wartości do swoich analiz. Do pełnego wykorzystania tej książki wymagana jest praktyczna znajomość usługi Power BI.  Pomocna będzie również podstawowa znajomość Pythona i R.

Do uruchomienia wszystkich plików kodu wykorzystanych w książce (rozdziały 1-16), może być potrzebne oprogramowanie wymienione na poniższej liście.

| Rodział  | Wymagane oprogramowanie                                                   | Wymagany OS                  |
| -------- | -------------------------------------------------------------------------------------| -----------------------------------|
|  	1-16	   |   	Power BI Desktop oraz Power BI Gateway                                			  | Windows(dowolna wersja) | 		
|  	1-16	   |   	Rstudio i VS Code                                			       | Windows(dowolna wersja) | 

Udostępniamy również plik PDF, który zawiera kolorowe obrazy zrzutów ekranu (wykresów) użytych w tej książce. [Kliknij, żeby pobrać](http://www.packtpub.com/sites/default/files/downloads/9781801078207_ColorImages.pdf).

### Powiązane produkty <Inne książki, które mogą Ci się spodobać>
* Microsoft   Power BI Cookbook - Second Edition [[Packt]](https://www.packtpub.com/product/microsoft-power-bi-cookbook-second-edition/9781801813044) [[Amazon]](https://www.amazon.in/Microsoft-Power-Cookbook-expertise-hands-ebook/dp/B09GKHW31G/ref=sr_1_3?keywords=Microsoft+Power+BI+Cookbook&qid=1638873909&sr=8-3)
  
* Expert Data Modeling with Power BI [[Packt]](https://www.packtpub.com/product/expert-data-modeling-with-power-bi/9781800205697) [[Amazon]](https://www.amazon.in/Expert-Data-Modeling-Power-optimized/dp/1800205694/ref=sr_1_2?keywords=Expert+Data+Modeling+with+Power+BI&qid=1638873830&sr=8-2)


  
## Poznaj autora
**Luca Zavarella** posiada certyfikat Azure Data Scientist Associate. Jest również posiadaczem tytułu Microsoft MVP w zakresie sztucznej inteligencji. Ukończył informatykę na Wydziale Inżynierii Uniwersytetu L'Aquila i ma ponad 10-letnie doświadczenie w pracy z Microsoft Data Platform. Karierę rozpoczął jako programista T-SQL na platformach SQL Server 2000 i 2005. Następnie skoncentrował uwagę na stosie technologicznym Microsoft Business Intelligence (SSIS, SSAS, SSRS) i pogłębił swoją wiedzę na temat technik hurtowni danych.  Ostatnio zajmował się zaawansowanymi zagadnieniami analitycznymi oraz technikami data science. Oprócz tego Luca z wyróżnieniem ukończył wydział klasycznego fortepianu w Konserwatorium „Alfredo Casella” w L'Aquila.
