library(odbc)
library(DBI)


# Nawiąż połączenie z egzemplarzem SQLExpress z wykorzystaniem uwierzytelniania systemu Windows
conn <- dbConnect(
  odbc::odbc(), server = r'{.\SQLExpress}',
  database = 'SystemsLogging', trusted_connection = 'yes',
  driver = '{ODBC Driver 17 for SQL Server}'
)

# Możesz również, jeśli wolisz, połączyć się z nim za pomocą uwierzytelniania SQL dla użytkownika 'sa'
# conn <- DBI::dbConnect(
#   odbc::odbc(), server = r'{.\SQLExpress}',
#   database = 'SystemsLogging', uid = 'sa',
#   pwd = '<twoje-hasło>',
#   driver = '{ODBC Driver 17 for SQL Server}'
# )

# Odczytaj i pokaż wybrane informacje o bazach danych przy użyciu widoku systemowego
data <- dbGetQuery(conn, "SELECT database_id, name FROM sys.databases")
head(data)

# Odłącz się od egzemplarza SQLExpress
dbDisconnect(conn)


# Nawiąż połączenie z Azure SQL Database
conn <- dbConnect(
  odbc::odbc(), server = 'lucazav.database.windows.net',
  database = 'SystemsLogging', uid = '<twoja-nazwa-użytkownika>',
  pwd = '<twoje-hasło>',
  driver = '{ODBC Driver 17 for SQL Server}'
)

# Odczytaj i pokaż wybrane informacje o bazach danych na serwerze Azure SQL przy użyciu widoku systemowego
data <- dbGetQuery(conn, "SELECT database_id, name FROM sys.databases")
head(data)


# Pobierz dane z przykładowej tabeli SalesLT.Customers
customers_df <- DBI::dbGetQuery(conn, "SELECT TOP 10 CustomerID AS UserId, EmailAddress AS Email FROM SalesLT.Customer")

# Zapisz dane customers_df do istniejącej tabeli WrongEmails
DBI::dbAppendTable(conn, name = 'WrongEmails', value = customers_df)


# Pobierz dane z tabeli WrongEmails i wyświetl je
df <- DBI::dbGetQuery(conn, "SELECT TOP 10 UserId, Email FROM WrongEmails")
head(df)


# Teraz opróżnij tabelę WrongEmails
dbSendQuery(conn, "TRUNCATE TABLE WrongEmails")

# Zamknij połączenie
dbDisconnect(conn)
