# TEN SKRYPT MA BYĆ URUCHAMIANY W JUPYTER NOTEBOOK (UŻYŁEM VS CODE)

# %%
import numpy as np
import pandas as pd

# %%
from sklearn.impute import KNNImputer
from sklearn.preprocessing import OrdinalEncoder
from sklearn.compose import ColumnTransformer

# %%
# Odkomentuj ten kod, jeśli nie używasz go w Power BI
# dataset = pd.read_csv('http://bit.ly/titanic-dataset-csv')
# dataset

# %%
# Pomińmy kolumnę 'Cabin', ponieważ zawiera zbyt dużo wartości NaN
# Pomijamy także kolumny PassengerId, Name i Ticket, ponieważ zawierają zbyt wiele odrębnych wartości
# pomijamy także te wiersze, w których Embarked ma wartość null
df_clean = dataset.drop(['Cabin','PassengerId','Name','Ticket'], axis=1)[dataset['Embarked'].notna()] 

# %%
# Pobierz indeksy kolumn funkcji kategorycznych (Sex i Embarked)
categorical_idx = df_clean.select_dtypes(include=['object', 'bool']).columns
# Zdefiniujmy transformator dla cech kategorycznych.
# Transformator to trzyelementowa krotka zdefiniowana przez nazwę transformatora, transformaty do zastosowania 
# oraz indeksy kolumn, do których ma zostać zastosowany. W tym przypadku do każdej kolumny kategorycznej stosujemy kodowanie Ordinal
t = [('cat', OrdinalEncoder(), categorical_idx)]
col_transform = ColumnTransformer(transformers=t)

# Pobierz tylko dwie przekształcone kolumny
X = col_transform.fit_transform(df_clean)

# Zastąp kolumny Sex i Embarked nowej ramki danych przekształconymi kolumnami
df_transf = df_clean.copy()
df_transf[categorical_idx.tolist()] = X

# %%
# Imputowanie wartości wieku za pomocą algorytmu knn
imputer = KNNImputer(n_neighbors=5, weights='uniform', metric='nan_euclidean', 
                     missing_values=np.nan, add_indicator=False)

# Dopasuj do oczyszczonej ramki danych
imputer.fit(df_transf)
# Przekształć ramkę danych zgodnie z imputerem i uzyskaj imputowaną macierz
matrix_imputed = imputer.transform(df_transf)

# %%
# Przekształcenie macierzy z powrotem na ramkę danych przy użyciu tych samych
# nazw kolumn oczyszczonej ramki danych
df_imputed = pd.DataFrame(matrix_imputed, columns=df_clean.columns)
df_imputed['Survived'] = df_imputed['Survived'].astype('int')

# %%
# Odkomentuj poniższy kod, jeśli nie używasz go w usłudze Power BI, ponieważ w kodzie szkoleniowym 
# zostanie wykorzystany imputowany zestaw danych.
# df_imputed.to_csv(r'C:\<twoja-ścieżka>\Chapter13\titanic-imputed.csv',
#                   index=False)

# %%
