import unittest
import json
from flask_error import app as tested_app

_404 = ('Żądany adres URL nie istnieje. ' 'Jeżeli wpisałeś go ręcznie, sprawdź go ' 'i spróbuj jeszcze raz.')

class TestApp(unittest.TestCase):
	def setUp(self):
		# Utworzenie klienta kontrolującego aplikację.
		self.app = tested_app.test_client()

	def test_raise(self):
		# Poniższy wiersz nie zgłasza wyjątku, tylko zwraca błąd nr 500.
		hello = self.app.get('/api')
		body = json.loads(str(hello.data, 'utf8'))
		self.assertEqual(body['code'], 500)

	def test_proper_404(self):
		# Wysłanie zapytania z nieistniejącą ścieżką.
		hello = self.app.get('/dwdwqqwdwqd')

		# Nie ma takiej ścieżki.
		self.assertEqual(hello.status_code, 404)

		# Jednak można uzyskać elegancką odpowiedź w formacie JSON.
		body = json.loads(str(hello.data, 'utf8'))
		self.assertEqual(body['code'], 404)
		self.assertEqual(body['message'], 'Ścieżka nie istnieje')
		self.assertEqual(body['description'], _404)

	if __name__ == '__main__':
	unittest.main()