package Pytanie18_2;

import CtCILibrary.AssortedMethods;

public class Pytanie {

	/* Liczba losowa z przedziału od lower do higher (włącznie) */
	public static int rand(int lower, int higher) { 
		return lower + (int)(Math.random() * (higher - lower + 1));
	}	
	
	public static int[] shuffleArrayRecursively(int[] cards, int i) {
		if (i == 0) {
			return cards;
		}
		
		/* Tasowanie elementów od 0 do i - 1 */
		shuffleArrayRecursively(cards, i - 1);
		int k = rand(0, i);		
		
		/* Przestawianie elementów k oraz i */
		int temp = cards[k];
		cards[k] = cards[i];
		cards[i] = temp;
		
		/* Zwracanie posortowanej tablicy */
		return cards;
 	}
	
	public static void shuffleArrayInteratively(int[] cards) { 
		for (int i = 0; i < cards.length; i++) { 
			int k = rand(0, i);
			int temp = cards[k];
			cards[k] = cards[i];
			cards[i] = temp;
		} 
	}
	
	public static void main(String[] args) {
		int[] cards = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
		System.out.println(AssortedMethods.arrayToString(cards));
		shuffleArrayInteratively(cards);
		System.out.println(AssortedMethods.arrayToString(cards));
	}

}
