package Pytanie18_11;

import CtCILibrary.AssortedMethods;

public class QuestionEff {
	public static Subsquare findSquareWithSize(SquareCell[][] processed, int square_size) {
		// Przy krawędzi o długości N jest (N - sz + 1) kwadratów o boku sz
		int count = processed.length - square_size + 1; 
		
		// Sprawdzanie wszystkich kwadratów o boku square_size
		for (int row = 0; row < count; row++) {
			for (int col = 0; col < count; col++) {
				if (isSquare(processed, row, col, square_size)) {
					return new Subsquare(row, col, square_size);
				}
			}
		}
		return null;
	}
	
	public static Subsquare findSquare(int[][] matrix){
		assert(matrix.length > 0);
		for (int row = 0; row < matrix.length; row++){
			assert(matrix[row].length == matrix.length);
		}
		
		SquareCell[][] processed = processSquare(matrix);
		
		int N = matrix.length;
		
		for (int i = N; i >= 1; i--) {
			Subsquare square = findSquareWithSize(processed, i);
			if (square != null) {
				return square;
			}
		}
		return null;
	}	

	private static boolean isSquare(SquareCell[][] matrix, int row, int col, int size) {
		SquareCell topLeft = matrix[row][col];
		SquareCell topRight = matrix[row][col + size - 1];
		SquareCell bottomRight = matrix[row + size - 1][col];
		if (topLeft.zerosRight < size) { // Sprawdzanie górnej krawędzi
			return false;
		}
		if (topLeft.zerosBelow < size) { // Sprawdzanie lewej krawędzi
			return false;
		}
		if (topRight.zerosBelow < size) { // Sprawdzanie prawej krawędzi
			return false;
		}
		if (bottomRight.zerosRight < size) { // Sprawdzanie dolnej krawędzi
			return false;
		}
		return true;
	}
	
	public static SquareCell[][] processSquare(int[][] matrix) {
		SquareCell[][] processed = new SquareCell[matrix.length][matrix.length];
		
		for (int r = matrix.length - 1; r >= 0; r--) {
			for (int c = matrix.length - 1; c >= 0; c--) {
				int rightZeros = 0;
				int belowZeros = 0;
				if (matrix[r][c] == 0) { // Dalsze operacje należy wykonać tylko dla czarnych komórek
					rightZeros++;
					belowZeros++;
					if (c + 1 < matrix.length) { // Następna kolumna znajduje się w tym samym wierszu
						SquareCell previous = processed[r][c + 1];
						rightZeros += previous.zerosRight;
					}
					if (r + 1 < matrix.length) {
						SquareCell previous = processed[r + 1][c];
						belowZeros += previous.zerosBelow;
					}
				}
				processed[r][c] = new SquareCell(rightZeros, belowZeros);
			}
		}	
		return processed;
	}
	
	public static void main(String[] args) {
		int[][] matrix = AssortedMethods.randomMatrix(7, 7, 0, 1);
		AssortedMethods.printMatrix(matrix);
		Subsquare square = findSquare(matrix);
		square.print();
	}
}
