package Pytanie17_5;

import java.util.Random;

public class Pytanie {

	public static class Result {
		public int hits;
		public int pseudoHits;
		
		public Result(int h, int p) {
			hits = h;
			pseudoHits = p;
		}
		
		public Result() {
		}
		
		public String toString() {
			return "(" + hits + ", " + pseudoHits + ")";
		}
	};
	
	public static int code(char c) {
		switch (c) {
		case 'C':
			return 0;
		case 'P':
			return 1;
		case 'Z':
			return 2;
		case 'N':
			return 3;
		default:
			return -1;
		}
	}
	
	public static int MAX_COLORS = 4;
	
	public static Result estimate(String guess, String solution) {
		if (guess.length() != solution.length()) return null;
		Result res = new Result();
		int[] frequencies = new int[MAX_COLORS];
		    
		/* Obliczanie trafień i tworzenie tablicy z liczbą wystąpień kolorów */
		for (int i = 0; i < guess.length(); i++) {
			if (guess.charAt(i) == solution.charAt(i)) {
				res.hits++;
			} else {
				/* Zwiększanie wartości w tablicy frequencies (posłuży ona do zliczania częściowych trafień),
				 * jeśli nie występuje trafienie. Jeśli odnotowano trafienie, dany element jest pomijany */
				int code = code(solution.charAt(i));
				if (code >= 0) {
					frequencies[code]++;
				}
			}
		}
		
		/* Obliczanie częściowych trafień */
		for (int i = 0; i < guess.length(); i++) {
			int code = code(guess.charAt(i));
			if (code >= 0 && frequencies[code] > 0 && guess.charAt(i) != solution.charAt(i)) {
				res.pseudoHits++;
				frequencies[code]--;
			}
		}
		return res;
	}

	/************************** KOD TESTU **********************************/
	
	public static char letterFromCode(int k) {
		switch (k) {
		case 0:
			return 'C';
		case 1:
			return 'P';
		case 2:
			return 'Z';
		case 3:
			return 'N';
		default:
			return '0';
		}		
	}
	
	public static Result estimateBad(String g, String s) {
		char[] guess = g.toCharArray();
		char[] solution = s.toCharArray();
		int hits = 0;
		for (int i = 0; i < guess.length; i++) {
			if (guess[i] == solution[i]) {
				hits++;
				solution[i] = '0';
				guess[i] = '0';
			}
		}
		
		int pseudohits = 0;
		
		for (int i = 0; i < guess.length; i++) {
			if (guess[i] != '0') {
				for (int j = 0; j < solution.length; j++) {
					if (solution[j] != '0') {
						if (solution[j] == guess[i]) {
							pseudohits++;
							solution[j] = '0';
							break;
						}
					}
				}
			}
		}
		
		return new Result(hits, pseudohits);
	}
	
	public static String randomString() {
		int length = 4;
		char[] str = new char[length];
		Random generator = new Random();
		
		for (int i = 0; i < length; i++) {
			int v = generator.nextInt(4);
			char c = letterFromCode(v);
			str[i] = c;
		}
		
		return String.valueOf(str);
	}
	
	public static boolean test(String guess, String solution) {
		Result res1 = estimate(guess, solution);
		Result res2 = estimateBad(guess, solution);
		if (res1.hits == res2.hits && res1.pseudoHits == res2.pseudoHits) {
			return true;
		} else {
			System.out.println("NIEPOWODZENIE: (" + guess + ", " + solution + "): " + res1.toString() + " | " + res2.toString());
			return false;
		}
	}
	
	public static boolean testRandom() {
		String guess = randomString();
		String solution = randomString();
		return test(guess, solution);
	}
	
	public static boolean test(int count) {
		for (int i = 0; i < count; i++) {
			if (!testRandom()) {
				return true;
			}
		}
		return false;
	}
	
	/********************** KONIEC KODU TESTU ************************/
	
	
	public static void main(String[] args) {
		test(1000);
	}
}
