package Pytanie8_2;

/* Employee to klasa bazowa klas Director, Manager i Respondent. Jest zaimplementowana jako
 * klasa abstrakcyjna, ponieważ nie trzeba bezpośrednio tworzyć obiektów typu Employee
 */
abstract class Employee {
	private Call currentCall = null;
	protected Rank rank;

	public Employee() {
	}

	/* Rozpoczynanie rozmowy */
	public void receiveCall(Call call) {
		currentCall = call;
	}

	/* Problem został rozwiązany, można zakończyć rozmowę */
	public void callCompleted() {
		if (currentCall != null) {
			/* Rozłączanie */
			currentCall.disconnect();

			/* Pracownik staje się dostępny */
			currentCall = null;
		}

		/* Sprawdzanie, czy w kolejce są oczekujące połączenia */
		assignNewCall();
	}

	/*
	 * Problem nie został rozwiązany. Należy przekazać rozmowę w górę i przypisać
	 * do pracownika nowe połączenie 
	 */
	public void escalateAndReassign() {
		if (currentCall != null) {
			/* Przekazywanie rozmowy w górę */
			currentCall.incrementRank();
			CallHandler.getInstance().dispatchCall(currentCall);

			/* Pracownik staje się dostępny */
			currentCall = null;
		}

		/* Przypisywanie nowego połączenia */
		assignNewCall();
	}

	/* Przypisywanie nowego połączenia do pracownika (jeśli jest on dostępny) */
	public boolean assignNewCall() {
		if (!isFree()) {
			return false;
		}
		return CallHandler.getInstance().assignCall(this);
	}

	/* Zwraca informację o tym, czy pracownik jest dostępny */
	public boolean isFree() {
		return currentCall == null;
	}

	public Rank getRank() {
		return rank;
	}
}
