package Wprowadzenie;

public class SitoEratostenesa {
	
	public static void crossOff(boolean[] flags, int prime) {
		/* Należy usunąć wielkrotności liczby pierwszej. Można zacząć
		 * od (prime*prime), ponieważ jeśli występuje wartość k * prime,
		 * gdzie < prime, została już ona wykreślona we wcześniejszych 
		 * iteracjach */		
		for (int i = prime * prime; i < flags.length; i += prime) {
			flags[i] = false;
		}
	}
	
	public static int getNextPrime(boolean[] flags, int prime) {
		int next = prime + 1;
		while (next < flags.length && !flags[next]) {
			next++;
		}
		return next;	
	}
	
	public static void init(boolean[] flags) {
		flags[0] = false;
		flags[1] = false;
		for (int i = 2; i < flags.length; i++) {
			flags[i] = true;
		}
	}
	
	public static int[] prune(boolean[] flags, int count) {
		int[] primes = new int[count];
		int index = 0;
		for (int i = 0; i < flags.length; i++) {
			if (flags[i]) {
				primes[index] = i;
				index++;
			}
		}
		return primes;
	}
	
	public static boolean[] sieveOfEratosthenes(int max) {
        boolean[] flags = new boolean[max + 1];
        int count = 0;
        
		init(flags);
        int prime = 2;
        
        while (prime <= Math.sqrt(max)) {
        	count++;        	
        	crossOff(flags, prime);
        	prime = getNextPrime(flags, prime);
        	if (prime >= flags.length) {
        		break;
        	}
        }
        
        return flags; //prune(flags, count);
	}
	
	public static void main(String[] args) {
		boolean[] primes = sieveOfEratosthenes(100);
		for (int i = 0; i < primes.length; i++) {
			if (primes[i]) {
				System.out.println(i);
			}
		}
	}

}
