package Pytanie8_2;

/* Reprezentuje połączenie z klientem. Połączenia mają określony poziom i są przypisywane do
 * pierwszego pracownika, który może obsłużyć połączenie z danego poziomu
 */
public class Call {
	/* Minimalny poziom pracownika, który może obsłużyć dane połączenie */
	private Rank rank;

	/* Dzwoniący klient */
	private Caller caller;

	/* Pracownik obsługujący połączenie */
	private Employee handler;

	public Call(Caller c) {
		rank = Rank.Responder;
		caller = c;
	}

	/* Ustawianie pracownika obsługującego połączenie */
	public void setHandler(Employee e) {
		handler = e;
	}

	/* Odtwarzanie klientowi nagranej wiadomości */
	public void reply(String message) {
		System.out.println(message);
	}

	public Rank getRank() {
		return rank;
	}

	public void setRank(Rank r) {
		rank = r;
	}

	public Rank incrementRank() {
		if (rank == Rank.Responder) {
			rank = Rank.Manager;
		} else if (rank == Rank.Manager) {
			rank = Rank.Director;
		}
		return rank;
	}

	/* Zrywanie połączenia */
	public void disconnect() {
		reply("Dziękujemy za rozmowę");
	}
}
