package Pytanie8_1;

public abstract class Card {
	private boolean available = true;
	
	/* Liczba lub figura karty. Dla liczb używane są wartości od 2 do 10, 
	 * 11 to walet, 12 to dama, 13 to król, a 1 to as 
	 */
	protected int faceValue;
	protected Suit suit;

	public Card(int c, Suit s) {
		faceValue = c;
		suit = s;
	}
	
	public abstract int value();
	
	public Suit suit() { 
		return suit; 
	}
	
	/* Informuje, czy karta jest dostępna */
	public boolean isAvailable() {
		return available;
	}
	
	public void markUnavailable() {
		available = false;
	}
	
	public void markAvailable() {
		available = true;
	}
	
	public void print() {
		String[] faceValues = {"A", "2", "3", "4", "5", "6", "7", "8", "9", "10", "W", "D", "K"};
		System.out.print(faceValues[faceValue - 1]);
		switch (suit) {
		case Club:
			System.out.print("trefl");
			break;
		case Heart:
			System.out.print("kier");
			break;
		case Diamond:
			System.out.print("karo");
			break;
		case Spade:
			System.out.print("pik");
			break;			
		}
		System.out.print(" ");
	}
}
