package Pytanie5_1;

import CtCILibrary.AssortedMethods;

public class Pytanie {

	public static int updateBits(int n, int m, int i, int j) {
		// Sprawdzanie poprawnoci
		if (i >= 32 || j < i) {
			return 0;
		}
		
		/* Tworzenie maski w celu wyzerowania bitw od i do j w n.
		/* PRZYKAD: i = 2, j = 4. Oczekiwany efekt to 11100011.
		 * W przykadzie uywanych jest osiem bitw
		 */
		int allOnes = ~0; // allOnes = 11111111
		
		int left = allOnes << (j + 1); // Jedynki do pozycji j, dalej zera. left = 11100000	
	  	int right = ((1 << i) - 1); // Jedynki po pozycji i.  right = 00000011
		int mask = left | right; // Same jedynki z wyjtkiem zer pomidzy i oraz j. mask = 11100011

		/* Zerowanie bitw od i do j, a nastpnie umieszczanie m na odpowiedniej pozycji */
		int n_cleared = n & mask; // Zerowanie bitw od j do i
		int m_shifted = m << i; // Ustawianie m na odpowiedniej pozycji
		
		/* Operacja OR i gotowe! */
		return n_cleared | m_shifted; 
	}
	
	public static void main(String[] args) {
		int a = 103217;
		System.out.println(AssortedMethods.toFullBinaryString(a));
		int b = 13;
		System.out.println(AssortedMethods.toFullBinaryString(b));		
		int c = updateBits(a, b, 4, 12);
		System.out.println(AssortedMethods.toFullBinaryString(c));
	}

}
