package Pytanie2_6;

import CtCILibrary.LinkedListNode;

public class Pytanie {

	public static LinkedListNode FindBeginning(LinkedListNode head) {
		LinkedListNode slow = head;
		LinkedListNode fast = head; 
		
		// Znajdowanie punktu spotkania wskaźników
		while (fast != null && fast.next != null) { 
			slow = slow.next; 
			fast = fast.next.next;
			if (slow == fast) {
				break;
			}
		}

		// Wykrywanie błędu - nie ma punktu spotkania, a więc pętla nie istnieje
		if (fast == null || fast.next == null) {
			return null;
		}

		/* Ustawianie wolnego wskaźnika na głowę, a szybkiego - na punkt spotkania. Oba te punkty występują k
		/* kroków od początku pętli. Jeśli wskaźniki będą przesuwane w tym samym tempie, spotkają się na 
		 * początku pętli */
		slow = head; 
		while (slow != fast) { 
			slow = slow.next; 
			fast = fast.next; 
		}
		
		// Teraz oba wskaźniki wskazują na początek pętli
		return fast;
	}
	
	public static void main(String[] args) {
		int list_length = 100;
		int k = 10;
		
		// Tworzenie listy powiązanej
		LinkedListNode[] nodes = new LinkedListNode[list_length];
		for (int i = 0; i < list_length; i++) {
			nodes[i] = new LinkedListNode(i, null, i > 0 ? nodes[i - 1] : null);
		}
		
		// Tworzenie pętli
		nodes[list_length - 1].next = nodes[list_length - k];
		
		LinkedListNode loop = FindBeginning(nodes[0]);
		if (loop == null) {
			System.out.println("Brak pętli");
		} else {
			System.out.println(loop.data);
		}
	}

}
