package Pytanie17_6;

import CtCILibrary.AssortedMethods;

public class Pytanie {

	public static int findEndOfLeftSubsequence(int[] array) {
		for (int i = 1; i < array.length; i++) {
			if (array[i] < array[i - 1]) {
				return i - 1;
			}
		}
		return array.length - 1;
	}
	
	public static int findStartOfRightSubsequence(int[] array) {
		for (int i = array.length - 2; i >= 0; i--) {
			if (array[i] > array[i + 1]) {
				return i + 1;
			}
		}
		return 0;
	}		
	
	public static int shrinkLeft(int[] array, int min_index, int start) {
		int comp = array[min_index];
		for (int i = start - 1; i >= 0; i--) {
			if (array[i] <= comp) {
				return i + 1;
			}
		}
		return 0;
	}
	
	public static int shrinkRight(int[] array, int max_index, int start) {
		int comp = array[max_index];
		for (int i = start; i < array.length; i++) {
			if (array[i] >= comp) {
				return i - 1;
			}
		}
		return array.length - 1;
	}	
	
	public static void findUnsortedSequence(int[] array) {
		// Znajdowanie lewej podsekwencji
		int end_left = findEndOfLeftSubsequence(array);	
		
		if (end_left >= array.length - 1) {
			//System.out.println("Tablica jest już posortowana.");
			return; // Tablica jest już posortowana
		}
		
		// Znajdowanie prawej podsekwencji
		int start_right = findStartOfRightSubsequence(array);	
		
		int max_index = end_left; // Maksimum dla lewej strony
		int min_index = start_right; // Minimum dla prawej strony
		for (int i = end_left + 1; i < start_right; i++) {
			if (array[i] < array[min_index]) {
				min_index = i;
			}
			if (array[i] > array[max_index]) {
				max_index = i;
			}
		}		
		
		// Przechodzenie w lewo do momentu uzyskania wartości mniejszej niż array[min_index]
		int left_index = shrinkLeft(array, min_index, end_left);

		// Przechodzenie w prawo do momentu uzyskania wartości większej niż array[max_index]
		int right_index = shrinkRight(array, max_index, start_right);
		
		if (validate(array, left_index, right_index)) {
			System.out.println("TRUE: " + left_index + " " + right_index);
		} else {
			System.out.println("FALSE: " + left_index + " " + right_index);
		}
	}
	
	/* Sprawdzanie, czy posortowanie elementów spomiędzy indeksów spowoduje
     * posortowanie tablicy. Zauważ, że nie jest to kompletne sprawdzanie,
	 * ponieważ kod nie bada, czy są to najlepsze możliwe indeksy
	 */
	public static boolean validate(int[] array, int left_index, int right_index) {
		int[] middle = new int[right_index - left_index + 1];
		for (int i = left_index; i <= right_index; i++) {
			middle[i - left_index] = array[i];
		}
		java.util.Arrays.sort(middle);
		for (int i = left_index; i <= right_index; i++) {
			array[i] = middle[i - left_index];
		}
		for (int i = 1; i < array.length; i++) {
			if (array[i-1] > array[i]) {
				return false;
			}		
		}
		return true;
	}
	
	public static void main(String[] args) {
		int[] array = {1, 2, 4, 7, 10, 11, 8, 12, 5, 7, 16, 18, 19};
		findUnsortedSequence(array);
	}

}
