package Pytanie17_4;

public class Pytanie {
	/* Zmienia 1 na 0 oraz 0 na 1 */
	public static int flip(int bit) {
		return 1 ^ bit;
	}	
	
	/* Zwraca 1 dla dodatnich a oraz 0 dla ujemnych a */
	public static int sign(int a) {
		return flip((a >> 31) & 0x1);
	}
	
	public static int getMaxNaive(int a, int b) {
		int k = sign(a - b);
		int q = flip(k);
		return a * k + b * q;
	}
	
	public static int getMax(int a, int b) {
		int c = a - b;
		
		int sa = sign(a); // Jeśli a >= 0, to 1; w przeciwnym razie 0
		int sb = sign(b); // Jeśli b >= 0, to 1; w przeciwnym razie 0
		int sc = sign(c); // Zależy od tego, czy operacja a - b powoduje przepełnienie
		
		/* Należy zdefiniować taką wartość k, która jest równa 1 dla a > b oraz jest równa 0 dla a < b 
		 * (przy a = b wartość k nie ma znaczenia) */
		
		int use_sign_of_a = sa ^ sb; // Jeśli a i b mają inne znaki, to k = sign(a)
		int use_sign_of_c = flip(sa ^ sb); // Jeśli a i b mają ten sam znak, to k = sign(a - b)
		
		/* Nie można zastosować operatora porównywania, jednak można mnożyć wartości przez 1 lub 0 */
		int k = use_sign_of_a * sa + use_sign_of_c * sc;
		int q = flip(k); // Wartość przeciwna do k
		
		return a * k + b * q;
	}	
	
	public static void main(String[] args) {
		int a = 26;
		int b = -15;
		
		System.out.println("max_naive(" + a + ", " + b + ") = " + getMaxNaive(a, b));
		System.out.println("max(" + a + ", " + b + ") = " + getMax(a, b));		
		
		a = -15;
		b = 2147483647;
		
		System.out.println("max_naive(" + a + ", " + b + ") = " + getMaxNaive(a, b));
		System.out.println("max(" + a + ", " + b + ") = " + getMax(a, b));
	}

}
