package Pytanie10_3;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;

public class Pytanie {
	public static long numberOfInts = ((long) Integer.MAX_VALUE) + 1;
	public static byte[] bitfield = new byte [(int) (numberOfInts / 8)];
	
	public static void findOpenNumber() throws FileNotFoundException {
		Scanner in = new Scanner(new FileReader("R10/Pytanie10_3/input_file_q10_3.txt"));
		while (in.hasNextInt()) {
			int n = in.nextInt ();
			/* Znajduje odpowiednią liczbę w tablicy bitfield, używając
			 * operatora OR do ustawienia n-tego bitu w bajcie 
			 * (np. 10 odpowiada 2. bitowi bajtu o indeksie 2 z tablicy bajtów) */
			bitfield [n / 8] |= 1 << (n % 8);
		}

		for (int i = 0; i < bitfield.length; i++) {
			for (int j = 0; j < 8; j++) {
				/* Pobiera pojedyncze bity każdego bajtu. Po wykryciu bitu 0 
				 * znajduje powiązaną wartość */
				if ((bitfield[i] & (1 << j)) == 0) {
					System.out.println (i * 8 + j);
					return;
				}
			}
		}		
	}

	public static void main(String[] args)  throws IOException {
		findOpenNumber();
	}

}
