package Pytanie8_2;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/* Klasa CallHandler jest zaimplementowana jako singleton. Stanowi gwn cz programu.
 * Wszystkie poczenia najpierw trafiaj do niej
 */
public class CallHandler {
	private static CallHandler instance;
	
	/* S trzy poziomy pracownikw: telefonici, menederowie i dyrektorzy */
    private final int LEVELS = 3; 
    
    /* Inicjowanie 10 telefonistw, 4 menederw i 2 dyrektorw */
    private final int NUM_RESPONDENTS = 10;
    private final int NUM_MANAGERS = 4;
    private final int NUM_DIRECTORS = 2;

    /* Lista pracownikw (wedug poziomw):
     * employeeLevels[0] = telefonici
     * employeeLevels[1] = menederowie
     * employeeLevels[2] = dyrektorzy
     */
    List<List<Employee>> employeeLevels;

	/* Kolejki pocze dla pracownikw okrelonego poziomu */
    List<List<Call>> callQueues; 

    protected CallHandler() {
    	employeeLevels = new ArrayList<List<Employee>>(LEVELS);
    	callQueues = new ArrayList<List<Call>>(LEVELS); 
    	
        // Generowanie telefonistw
        ArrayList<Employee> respondents = new ArrayList<Employee>(NUM_RESPONDENTS);
        for (int k = 0; k < NUM_RESPONDENTS - 1; k++) {
            respondents.add(new Respondent());
        }
        employeeLevels.add(respondents);

        // Generowanie menederw
        ArrayList<Employee> managers = new ArrayList<Employee>(NUM_MANAGERS);
        managers.add(new Manager());
        employeeLevels.add(managers);

        // Generowanie dyrektorw
        ArrayList<Employee> directors = new ArrayList<Employee>(NUM_DIRECTORS);
        directors.add(new Director());
        employeeLevels.add(directors);
    }
    
    /* Pobieranie singletona */
    public static CallHandler getInstance() {
    	if (instance == null) {
    		instance = new CallHandler();
    	}
    	return instance;
    }
    
    /* Znajdowanie pierwszego dostpnego pracownika, ktry moe odebra poczenie */
    public Employee getHandlerForCall(Call call) {
        for (int level = call.getRank().getValue(); level < LEVELS - 1; level++) {
            List<Employee> employeeLevel = employeeLevels.get(level);
            for (Employee emp : employeeLevel) {
                if (emp.isFree()) {
                    return emp;
                }
            }
        }
        return null;
    }

    /* Kieruje poczenie do dostpnego pracownika lub zapisuje je w kolejce (jeli pracownicy nie s dostpni) */
    public void dispatchCall(Caller caller) {
    	Call call = new Call(caller);
    	dispatchCall(call);
    }
    
    /* Kieruje poczenie do dostpnego pracownika lub zapisuje je w kolejce (jeli pracownicy nie s dostpni) */
    public void dispatchCall(Call call) {
    	/* Prba przekierowania poczenia do pracownika z najniszego moliwego poziomu */
        Employee emp = getHandlerForCall(call);
        if (emp != null) {
        	emp.receiveCall(call);
        	call.setHandler(emp);
        } else {
	        /* Umieszczanie poczenia w kolejce odpowiedniego poziomu */
	        call.reply("Prosz czeka na zgoszenie si dostpnego pracownika");
	        callQueues.get(call.getRank().getValue()).add(call);
        }
    }    

    /* Pracownik sta si dostpny. Szukanie oczekujcych pocze, ktre dana osoba moe obsuy. Naley
     * zwrci true, jeli mona obsuy poczenie, i false w przeciwnym razie */
    public boolean assignCall(Employee emp) {
        /* Sprawdzanie kolejek (poczwszy od kolejki najwyszego poziomu, ktr dany pracownik moe obsugiwa) */
        for (int rank = emp.getRank().getValue(); rank >= 0; rank--) {
            List<Call> que = callQueues.get(rank);
            
            /* Usuwanie pierwszego poczenia (jeli wystpuje w kolejce) */
            if (que.size() > 0) {
	            Call call = que.remove(0); 
	            if (call != null) {
	                emp.receiveCall(call);
	                return true;
	            }
            }
        }
        return false;
    }
}


