package Pytanie18_12;

import CtCILibrary.AssortedMethods;

public class PytanieC {
	
	public static void clearArray(int[] array) {
		for (int i = 0; i < array.length; i++) {
			array[i] = 0;
		}
	}
	
	public static int maxSubMatrix(int[][] matrix) {
		int rowCount = matrix.length;
		int colCount = matrix[0].length;
	
		int[] partialSum = new int[colCount]; 
		int maxSum = 0; // Maksymalną sumę daje pusta macierz
	
		for (int rowStart = 0; rowStart < rowCount; rowStart++) {
			clearArray(partialSum);
		
			for (int rowEnd = rowStart; rowEnd < rowCount; rowEnd++) {
				for (int i = 0; i < colCount; i++) {
					partialSum[i] += matrix[rowEnd][i];
				}
		
				int tempMaxSum = maxSubArray(partialSum, colCount);
				
				// Jeśli chcesz rejestrować współrzędne, 
				// dodaj tu potrzebny kod
				maxSum = Math.max(maxSum, tempMaxSum);
			}
		}
		return maxSum;
	}

	public static int maxSubArray(int array[], int N) {
		int maxSum = 0;
		int runningSum = 0;

		for (int i = 0; i < N; i++) {
			runningSum += array[i];
			maxSum = Math.max(maxSum, runningSum);
			
			/* Jeśli running_sum < 0, nie ma sensu kontynuowanie obliczeń.
			 * Należy wyzerować zmienną running_sum */
			if (runningSum < 0) {
				runningSum = 0;
			}
		}

		return maxSum;
	}
	
	public static void main(String[] args) {
		int[][] matrix = AssortedMethods.randomMatrix(5, 7, -100, 100);
		int sum = maxSubMatrix(matrix);
		AssortedMethods.printMatrix(matrix);
		System.out.println(sum);
	}

}
