package Pytanie8_8;

public class Board {
	private int blackCount = 0;
	private int whiteCount = 0;
	private Piece[][] board;
	
	public Board(int rows, int columns) {
		board = new Piece[rows][columns];
	}
	
	public void initialize() {
		/* Początkowo na planszy znajdują się pośrodku następujące pionki:
		 *     BC
		 *     CB
		 */
		int middleRow = board.length / 2;
		int middleColumn = board[middleRow].length / 2;
		board[middleRow][middleColumn] = new Piece(Color.White);
		board[middleRow + 1][middleColumn] = new Piece(Color.Black);
		board[middleRow + 1][middleColumn + 1] = new Piece(Color.White);
		board[middleRow][middleColumn + 1] = new Piece(Color.Black);
		blackCount = 2;
		whiteCount = 2;
	}
	
	public boolean placeColor(int row, int column, Color color) {
		if (board[row][column] != null) {
			return false;
		}
		
		/* Próba zmiany kolorów pionków w każdym z czterech kierunków */
		int[] results = new int[4];
		results[0] = flipSection(row - 1, column, color, Direction.up);
		results[1] = flipSection(row + 1, column, color, Direction.down);
		results[2] = flipSection(row, column + 1, color, Direction.right);
		results[3] = flipSection(row, column - 1, color, Direction.left);
		
		/* Obliczanie, ile pionków odwrócono */
		int flipped = 0;
		for (int result : results) {
			if (result > 0) {
				flipped += result;
			}
		}
		
		/* Jeśli nie odwrócono żadnego pionka, ruch jest nieprawidłowy */
		if (flipped < 0) {
			return false;
		}
		
		/* Odwracanie pionka i aktualizowanie wyniku */
		board[row][column] = new Piece(color);
		updateScore(color, flipped + 1);
		return true;
	}
	
	private int flipSection(int row, int column, Color color, Direction d) {
		/* Obliczanie zmian w wierszlu i kolumnie. Zmiany zawsze dotyczą albo wiersza, 
		 * albo kolumny, ponieważ są dokonywane tylko w jednym kierunku jednocześnie
		 */
		int r = 0;
		int c = 0;
		switch (d) {
		case up:
			r = -1;
			break;
		case down:
			r = 1;
			break;
		case left:
			c = -1;
			break;
		case right:
			c = 1;
			break;
		}
		
		/* Wyjście poza planszę lub brak odwróconych pionków wymaga zwrócenia błędu (-1) */
		if (row < 0 || row >= board.length || column < 0 || column >= board[row].length || board[row][column] == null) {
			return -1;
		}
		
		/* Znaleziono piontek tego samego koloru - należy poinformować o tym, że żaden pionek nie został odwrócony */
		if (board[row][column].getColor() == color) {
			return 0;
		}
		
		/* Rekurencyjne odwracanie pozostałych pionków w wierszu. Jeśli zwrócono wartość -1, 
		 * wiadomo, że natrafiono na granicę wiersza 
		 * (lub puste pole) przed wykryciem pionka danego koloru, dlatego nie ma czego odwracać. 
		 * Należy zwrócić kod błędu
		 */
		int flipped = flipSection(row + r, column + c, color, d);
		if (flipped < 0) {
			return -1;
		}
		
		/* Odwracanie pionka */
		board[row][column].flip();
		return flipped + 1;
	}
	
	public int getScoreForColor(Color c) {
		if (c == Color.Black) {
			return blackCount;
		} else {
			return whiteCount;
		}
	}
	
	public void updateScore(Color newColor, int newPieces) {
		/* Jeśli dodano x pionków danego koloru, usunięto x - 1 pionków przeciwnego
		 * koloru. Wartość -1 wynika z tego, że jeden z nowych pionków został właśnie dodany
		 */
		if (newColor == Color.Black) {
			whiteCount -= newPieces - 1;
			blackCount += newPieces;
		} else {
			blackCount -= newPieces - 1;			
			whiteCount += newPieces;
		}
	}
	
	public void printBoard() {
		for (int r = 0; r < board.length; r++) {
			for (int c = 0; c < board[r].length; c++) {
				if (board[r][c] == null) {
					System.out.print("_");
				} else if (board[r][c].getColor() == Color.White) {
					System.out.print("B");
				} else {
					System.out.print("C");
				}
			}
			System.out.println();
		}
	}
}
