package Pytanie5_3;

public class Pytanie {

	public static int countOnes(int i) {
		int count = 0;
		while (i > 0) {
			if ((i & 1) == 1) {
				count++;
			}
			i = i >> 1;
		}
		return count;
	}
	
	public static int countZeros(int i) {
		return 32 - countOnes(i);
	}	
	
	public static boolean hasValidNext(int i) {
		if (i == 0) {
			return false;
		}
		int count = 0;
		while ((i & 1) == 0) {
			i >>= 1;
			count++;
		}
		while ((i & 1) == 1) {
			i >>= 1;
			count++;
		}		
		if (count == 31) {
			return false;
		}
		return true;	
	}
	
	public static boolean hasValidPrev(int i) {
		while ((i & 1) == 1) {
			i >>= 1;
		}
		if (i == 0) {
			return false;
		}
		return true;		
	}

	public static int getNextSlow(int i) {
		if (!hasValidNext(i)) {
			return -1;
		}
		int num_ones = countOnes(i);
		i++;
		while (countOnes(i) != num_ones) {
			i++;
		}
		return i;
	}

	public static int getPrevSlow(int i) {
		if (!hasValidPrev(i)) {
			return -1;
		}		
		int num_ones = countOnes(i);
		i--;
		while (countOnes(i) != num_ones) {
			i--;
		}
		return i;
	}
	
	public static int getNext(int n) {
		int c = n;
		int c0 = 0;
		int c1 = 0;
		while (((c & 1) == 0) && (c != 0)) {
			c0++;
			c >>= 1;
		}
		
		while ((c & 1) == 1) {
			c1++;
			c >>= 1;
		}
		
		/* Jeśli c to 0, to n jest sekwencją jedynek, po której następuje sekwencja zer. Jest to już największa
		 * wartość o c1 jedynek. Należy zwrócić błąd
		 */
		if (c0 + c1 == 31 || c0 + c1 == 0) {
			return -1;
		}
		
		int pos = c0 + c1; // Pozycja ostatniego zera, po którym następują jedynki
		
		n |= (1 << pos); // Zmiana ostatniego zera, po którym następują jedynki
				
		/* Zerowanie wszystkich bitów na prawo od pos
		 * Przykład dla pos = 5 
		 * (1) Przesuwanie 1 o 5, aby utworzyć 0..0100000       [ mask = 1 << pos ]
		 * (2) Odejmowanie 1, aby uzyskać 0..0011111            [ mask = mask - 1 ]
		 * (3) Przestawianie wszystkich bitów za pomocą '~', aby uzyskać 1..1100000 [ mask = ~mask    ]
		 * (4) Operacja AND z n
		 */
		n &= ~((1 << pos) - 1); // Zerowanie wszystkich bitów na prawo od pos
		
		/* Umieszczanie (ones-1) jedynek po prawej stronie w następujący sposób:
		 * (1) Przesuwanie 1 o (ones-1) miejsc. Jeśli ones = 3, wynik to 0..0100
		 * (2) Odejmowanie 1, aby uzyskać 0..0011
		 * (3) Operacja OR z n
		 */
		n |= (1 << (c1 - 1)) - 1;
		
		return n;
	}
	
	public static int getNextArith(int n) {
		int c = n;
		int c0 = 0;
		int c1 = 0;
		while (((c & 1) == 0) && (c != 0)) {
			c0++;
			c >>= 1;
		}
		
		while ((c & 1) == 1) {
			c1++;
			c >>= 1;
		}
		
		/* Jeśli c to 0, to n jest sekwencją jedynek, po której następuje sekwencja zer. Jest to 
		 * już największa liczba o c1 jedynek. Należy zwrócić błąd
		 */
		if (c0 + c1 == 31 || c0 + c1 == 0) {
			return -1;
		}
		
		/* Operacje arytmetyczne:
		 * 2^c0 = 1 << c0
		 * 2^(c1-1) = 1 << (c0 - 1)
		 * next = n + 2^c0 + 2^(c1-1) - 1;
		 */
		
		return n + (1 << c0) + (1 << (c1 - 1)) - 1;
	}	
	
	public static int getPrev(int n) {
		int temp = n;
		int c0 = 0;
		int c1 = 0;
		while ((temp & 1) == 1) {
			c1++;
			temp >>= 1;
		}
		
		/* Jeśli temp to 0, to liczba jest sekwencją zer, po której następuje sekwencja jedynek. Jest to już
		 * najmniejsza liczba o c1 jedynek. Należy zwrócić -1 oznaczające błąd
		 */
		if (temp == 0) { 
			return -1;
		}
		
		while (((temp & 1) == 0) && (temp != 0)) {
			c0++;
			temp >>= 1;
		}

		int p = c0 + c1; // Pozycja ostatniej jedynki, po której następują zera (gdzie prawy bit to 0)

		/* Zmiana prawej jedynki, po której następują zera. 
		 * Przykład: n = 00011100011.
		 * c1 = 2
		 * c0 = 3
		 * pos = 5
		 * 
		 * Tworzenie maski w następujący sposób:
		 * (1) ~0 to sekwencja jedynek
		 * (2) Przesuwanie w lewo o p + 1 daje 11.111000000 (sześć zer) 
		 * (3) Operacja AND z n powoduje wyzerowanie ostatnich sześciu bitów
		 * Teraz n to 00011000000
		 */
		n &= ((~0) << (p + 1)); // Zerowanie bitów od p w prawo
		
		/* Tworzenie sekwencji (c1+1) jedynek w następujący sposób:
		 * (1) Przesuwanie 1 w lewo (c1+1) razy. Jeśli c1 to 2, wynik to 0..001000
		 * (2) Odejmowanie 1 od wyniku. Efekt to 0..00111
		 */
		int mask = (1 << (c1 + 1)) - 1; // Sekwencja (c1+1) jedynek
		
		/* Przesuwanie jedynek do pozycji p		 
		 * Ponieważ liczba to sekwencja (c1+1) jedynek, a p = c1 + c0, trzeba
		 * przesunąć ją o (c0-1) pozycji.
		 * Jeśli c0 = 3 i c1 = 2, wynik wygląda tak: 00...0011100
		 * 
		 * Na zakończenie wykonywana jest operacja OR z n.
		 */
		n |= mask << (c0 - 1);  
		
		return n;		
	}
	
	public static int getPrevArith(int n) {
		int temp = n;
		int c0 = 0;
		int c1 = 0;
		while (((temp & 1) == 1) && (temp != 0)) {
			c1++;
			temp >>= 1;
		}
		
		/* Jeśli temp to 0, to liczba jest sekwencją zer, po której następuje sekwencja jedynek. Jest to już
		 * najmniejsza liczba o c1 jedynek. Należy zwrócić -1 oznaczające błąd
		 */
		if (temp == 0) { 
			return -1;
		}
		
		while ((temp & 1) == 0 && (temp != 0)) {
			c0++;
			temp >>= 1;
		}

		/* Operacje arytmetyczne:
		 * 2^c1 = 1 << c1
		 * 2^(c0 - 1) = 1 << (c0 - 1)
		 */
		return n - (1 << c1) - (1 << (c0 - 1)) + 1;		
	}	
	
	public static void binPrint(int i) {
		System.out.println(i + ": " + Integer.toBinaryString(i));		
	}
	
	public static void main(String[] args) {
		for (int i = 0; i < 200; i++) {
			int p1 = getPrevSlow(i);
			int p2 = getPrev(i);
			int p3 = getPrevArith(i);
			
			int n1 = getNextSlow(i);
			int n2 = getNext(i);
			int n3 = getNextArith(i);
			
			if (p1 != p2 || p2 != p3 || n1 != n2 || n2 != n3) {
				binPrint(i);
				binPrint(p1);
				binPrint(p2);
				binPrint(p3);
				binPrint(n1);
				binPrint(n2);
				binPrint(n3);
				System.out.println("");
			}			
		}
		System.out.println("Gotowe!");
	}

}
