package Pytanie9_9;

import java.util.ArrayList;

public class Pytanie {
	public static int GRID_SIZE = 8;
	
	/* Sprawdzanie, czy (row1, column1) to odpowiednie miejsce dla hetmana. Wymaga to ustalenia, czy w danej
	 * kolumnie lub przekątnej znajduje się już hetman. Nie trzeba sprawdzać, czy hetman znajduje się w danym
	 * wierszu, ponieważ wywołanie placeQueen dodaje tylko jednego hetmana naraz.
	 * Wiadomo więc, że dany wiersz jest pusty. 
	 */
	public static boolean checkValid(Integer[] columns, int row1, int column1) {
		for (int row2 = 0; row2 < row1; row2++) {
			int column2 = columns[row2];
			/* Sprawdzanie, czy pole (row2, column2) uniemożliwia ustawienie hetmana na polu (row1, column1) */
			
			/* Sprawdzanie, czy w wierszach hetmany nie powtarzają się w którejś z kolumn */
			if (column1 == column2) { 
				return false;
			}
			
			/* Sprawdzanie przekątnych - jeśli odległość między kolumnami jest równa odległości
			 * między wierszami, pola znajdują się na tej samej przekątnej
			 */
			int columnDistance = Math.abs(column2 - column1); 
			int rowDistance = row1 - row2; // row1 > row2, dlatego trzeba zastosować wartość bezwzględną
		    if (columnDistance == rowDistance) {
		    	return false;
		    }
		}
		return true;
	}
	
	public static void placeQueens(int row, Integer[] columns, ArrayList<Integer[]> results) {
		if (row == GRID_SIZE) { // Znalezienie właściwego miejsca
			results.add(columns.clone()); 
		} else {
			for (int col = 0; col < GRID_SIZE; col++) {			
				if (checkValid(columns, row, col)) {
					columns[row] = col;	// Wstawienie hetmana
					placeQueens(row + 1, columns, results);	
				}		
			}
		}
	}
	
	public static void clear(Integer[] columns) {
		for (int i = 0; i < GRID_SIZE; i++) {
			columns[i] = -1;
		}
	}
	
	public static void printBoard(Integer[] columns) {
        drawLine();
        for(int i = 0; i < GRID_SIZE; i++){
			System.out.print("|");
			for (int j = 0; j < GRID_SIZE; j++){
			    if (columns[i] == j) {
			    	System.out.print("H|");
			    } else {
			    	System.out.print(" |");
			    }
			}
            System.out.print("\n");
            drawLine();
		}
		System.out.println("");
	}

    private static void drawLine() {
        StringBuilder line = new StringBuilder();
        for (int i=0;i<GRID_SIZE*2+1;i++)
            line.append('-');
        System.out.println(line.toString());
    }


	
	public static void printBoards(ArrayList<Integer[]> boards) {
		for (int i = 0; i < boards.size(); i++) {
			Integer[] board = boards.get(i);
			printBoard(board);
		}
	}
	   
	public static void main(String[] args) {
		ArrayList<Integer[]> results = new ArrayList<Integer[]>();
		Integer[] columns = new Integer[GRID_SIZE];
		clear(columns);
		placeQueens(0, columns, results);
		printBoards(results);
		System.out.println(results.size());
	}
}
