package Pytanie9_2;

import java.util.ArrayList;
import java.util.Hashtable;
import java.awt.*;

import CtCILibrary.AssortedMethods;

public class PytanieDP {
	public static int size = 4;
	public static int[][] maze = new int[size][size];
	
	public static boolean isFree(int x, int y) {
		if (maze[x][y] == 0) {
			return false;
		} else {
			return true;
		}
	}
	
	public static boolean getPath(int x, int y, ArrayList<Point> path) {
		// Jeśli wartość jest poza zakresem lub jest niedostępna, należy zwrócić sterowanie
		if (y < 0 || x < 0 || !isFree(x, y)) {
			return false;
		}
		
		boolean isAtOrigin = (x == 0) && (y == 0);
		
		// Jeśli istnieje ścieżka od początku do bieżącej lokalizacji, należy dodać tę lokalizację
		if (isAtOrigin || getPath(x, y - 1, path) || getPath(x - 1, y, path)) { 
			Point p = new Point(x, y);
			path.add(p);
			return true;
		}
		
		return false;
	}	

	public static boolean getPath(int x, int y, ArrayList<Point> path, Hashtable<Point, Boolean> cache) {
		/* Jeśli wartość jest poza zakresem lub jest niedostępna, należy zwrócić sterowanie */
		if (y < 0 || x < 0 || !isFree(x, y)) {
			return false;
		}
		Point p = new Point(x, y);
		
		/* Jeśli daną komórkę już odwiedzono, należy zwrócić sterowanie */
		if (cache.containsKey(p)) { 
			return cache.get(p);
		}	
		
		boolean isAtOrigin = (x == 0) && (y == 0);
		boolean success = false;
		
		/* Jeśli istnieje ścieżka od początku do bieżącej lokalizacji, należy dodać tę lokalizację */
		if (isAtOrigin || getPath(x, y - 1, path, cache) || getPath(x - 1, y, path, cache)) {
			path.add(p);
			success = true;
		}
		
		cache.put(p, success); // Zapisywanie wyniku w pamięci podręcznej
		return success;
	}
	
	public static void main(String[] args) {
		maze = AssortedMethods.randomMatrix(size, size, 0, 5);
		AssortedMethods.printMatrix(maze);
		ArrayList<Point> path = new ArrayList<Point>();
		Hashtable<Point, Boolean> cache = new Hashtable<Point, Boolean>();
		boolean success = getPath(size - 1, size - 1, path, cache);
		
		if (success) {
			String s = AssortedMethods.listOfPointsToString(path);
			System.out.println("Ścieżka: " + " " + s);			
		} else {
			System.out.println("Ścieżka nie istnieje.");
		}
	}

}
