package Pytanie7_6;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Pytanie {	
	
	/* Zliczanie  w tablicy linii "równych" danej linii (których nachylenie i 
	 * punkt przecięcia z osią y nie różnią się od tej linii o więcej niż epsilon) 
	 */
	public static int countEquivalentLines(ArrayList<Line> lines, Line line) {
		if (lines == null) {
			return 0;
		}
		
		int count = 0;
		for (Line parallelLine : lines) {
			if (parallelLine.isEquivalent(line)) {
				count++;
			}
		}
		return count;		
	}
	
	/* Szukanie w odwzorowaniu "równych" linii. Zauważ, że trzeba sprawdzić nachylenie o epsilon większe i mniejsze,
	 * ponieważ dwie linie są uznawane za równe, jeśli nie różnią się o więcej niż epsilon
	 */
	public static int countEquivalentLines(HashMap<Double, ArrayList<Line>> linesBySlope, Line line) {
		double key = Line.floorToNearestEpsilon(line.slope);
		int count = countEquivalentLines(linesBySlope.get(key), line);
		count += countEquivalentLines(linesBySlope.get(key - Line.epsilon), line);
		count += countEquivalentLines(linesBySlope.get(key + Line.epsilon), line);
		return count;
	}	
	
	/* Dodawanie linii do odwzorowania */
	public static void insertLine(HashMap<Double, ArrayList<Line>> linesBySlope, Line line) {
		ArrayList<Line> lines = null;
		double key = Line.floorToNearestEpsilon(line.slope);
		if (!linesBySlope.containsKey(key)) {
			lines = new ArrayList<Line>();
			linesBySlope.put(key, lines);
		} else {
			lines = linesBySlope.get(key);
		}
		lines.add(line);
	}
	
	
	public static Line findBestLine(GraphPoint[] points) {
		Line bestLine = null;
		int bestCount = 0;
		HashMap<Double, ArrayList<Line>> linesBySlope = new HashMap<Double, ArrayList<Line>>();
		
		for (int i = 0; i < points.length; i++) {
			for (int j = i + 1; j < points.length; j++) {
				Line line = new Line(points[i], points[j]);
				insertLine(linesBySlope, line);
				
				/* Zliczanie linii "równych" danej */
				int count = countEquivalentLines(linesBySlope, line);
				
				/* Jeśli nowa linia jest lepsza od najlepszej z dotychczasowych, 
				 * należy ustawić nową linię jako najlepszą */
				if (count > bestCount) {
					bestLine = line;
					bestCount = count;
				}
			}
		} 
		
		return bestLine;
	}	
	
	public static GraphPoint[] createPoints() {
		int n_points = 100;
		System.out.println("Punkty grafu\n***************");
		GraphPoint[] points = new GraphPoint[n_points - 1];
		for (int i = 0; i < n_points / 2; i++) {
			GraphPoint p = new GraphPoint(i, 2.3 * ((double)i) + 20.0);
			points[i] = p;
			System.out.println(p.toString());
		}
		for (int i = 0; i < n_points / 2 - 1; i++) {
			GraphPoint p = new GraphPoint(i, 3.0 * ((double)i) + 1.0);
			points[n_points / 2 + i] = p;
			System.out.println(p.toString());
		}
		System.out.println("****************\n");
		return points;
	}
	
	public static void main(String[] args) {
		GraphPoint[] points = createPoints();
		Line line = findBestLine(points);
		line.Print();
	}
}
