package Pytanie2_2;

import CtCILibrary.*;

public class Pytanie {

	public static int nthToLastR1(LinkedListNode head, int n) {
		if (n == 0 || head == null) {
			return 0;
		}
		int k = nthToLastR1(head.next, n) + 1;
		if (k == n) {
			System.out.println(n + ". węzeł od końca to " + head.data);
		}
		return k;
	}
	
	public static LinkedListNode nthToLastR2(LinkedListNode head, int n, IntWrapper i) {
		if (head == null) {
			return null;
		}
		LinkedListNode node = nthToLastR2(head.next, n, i);
		i.value = i.value + 1;
		if (i.value == n) {
			return head;
		} 
		return node;
	}
	
	public static Result nthToLastR3Helper(LinkedListNode head, int k) {
		if (head == null) {
			return new Result(null, 0);
		}
		Result res = nthToLastR3Helper(head.next, k);
		if (res.node == null) {
			res.count++;
			if (res.count == k) {
				res.node = head;
			} 
		}
		return res;
	}	
	
	public static LinkedListNode nthToLastR3(LinkedListNode head, int k) {
		Result res = nthToLastR3Helper(head, k);
		if (res != null) {
			return res.node;
		}
		return null;
	}		
	
	public static LinkedListNode nthToLast(LinkedListNode head, int n) {
		LinkedListNode p1 = head;
		LinkedListNode p2 = head;
		
		if (n <= 0) return null;
		
		// Przesuwanie p2 o n węzłów dalej na liście. n1 pozostaje w tym samym miejscu
		for (int i = 0; i < n - 1; i++) { 
			if (p2 == null) {
				return null; // Błąd: lista jest za mała
			}
			p2 = p2.next;
		}
		if (p2 == null) { // Wykrywanie błędów
			return null;
		}
		
		// Teraz należy przesuwać p1 i p2 z tą samą szybkością. Gdy p2 dojdzie do końca, 
		// p1 będzie wskazywać odpowiedni element
		while (p2.next != null) {
			p1 = p1.next;
			p2 = p2.next;
	  	}
	  	return p1;
	}
	
	public static void main(String[] args) {
		LinkedListNode head = AssortedMethods.randomLinkedList(10, 0, 10);
		System.out.println(head.printForward());
		int nth = 3;
		IntWrapper wr = new IntWrapper();
		LinkedListNode n = nthToLastR3(head, nth);
		nthToLastR1(head, nth);
		if (n != null) {
			System.out.println(nth + ". węzeł od końca to " + n.data);
		} else {
			System.out.println("Null. n poza zakresem.");
		}
	}

}
