package Pytanie18_13;

import CtCILibrary.Trie;

/* Klasa reprezentująca prostokątną tablicę liter */
public class Rectangle {
    
    // Dane prostokąta
    public int height;
    public int length; 
    public char [][] matrix;

    public Rectangle(int len) {
        this.length = len;
    }

	 /* Tworzy prostokątną tablicę liter o określonej długości i wysokości.
	  * Przyjmij, że długość i wysokość podane jako argumenty są spójne z
	  * wymiarami przekazanej tablicy 
	  */
    public Rectangle(int length, int height, char[][] letters) {
        this.height = letters.length;
        this.length = letters[0].length;
        matrix = letters;
    }

    /* Zwraca literę z określonego miejsca tablicy
     */
    public char getLetter (int i, int j) {
        return matrix[i][j];
    }
    
    public String getColumn(int i) {
		char[] column = new char[height];
		for (int j = 0; j < height; j++) {
			column[j] = getLetter(j, i);
		}
		return new String(column);
    }
    
    public boolean isComplete(int l, int h, WordGroup groupList) {
		// Sprawdza, czy utworzono kompletny prostokąt
		if (height == h) {
			// Sprawdza, czy w każdej kolumnie znajduje się słowo ze słownika
			for (int i = 0; i < l; i++) {
				String col = getColumn(i);
				if (!groupList.containsWord(col)) {
					return false; // Prostokąt jest nieprawidłowy
				}
			}
			return true; // Prostokąt jest prawidłowy
		}
		return false;
    }
    
    public boolean isPartialOK(int l, Trie trie) {
    	if (height == 0) {
    		return true;
    	}
		for (int i = 0; i < l ; i++ ) {
			String col = getColumn(i);
			if (!trie.contains(col)) {
				return false; // Prostokąt jest nieprawidłowy
			}
		}
		return true;
    }

	 /* Jeśli długość argumentu s jest zgodna z długością obiektu Rectangle,
	  * należy zwrócić obiekt Rectangle utworzony w wyniku dodania s do
	  * istniejącej macierzy. W przeciwnym razie należy zwrócić null. 
	  * Pierwotna macierz reprezentująca obiekt Rectangle nie jest modyfikowana
	  */
    public Rectangle append(String s) {
        if (s.length() == length) {
            char temp[][] = new char[height + 1][length];
            for (int i = 0; i < height; i++) {
                for (int j = 0; j < length; j++) {
                    temp[i][j] = matrix[i][j];
                }
            }
            s.getChars(0, length, temp[height], 0);

            return new Rectangle(length, height + 1, temp);
        }
        return null;
    }

    /* Wyświetla prostokąt wiersz po wierszu */
    public void print() {
        for (int i = 0; i < height ; i++) {
            for (int j = 0; j < length; j++) {
                System.out.print(matrix[i][j]);
            }
            System.out.println(" ");
        }
    }
}
