package Pytanie8_4;

public class ParkingSpot {
	private Vehicle vehicle;
	private VehicleSize spotSize;
	private int row;
	private int spotNumber;
	private Level level;
	
	public ParkingSpot(Level lvl, int r, int n, VehicleSize sz) {
		level = lvl;
		row = r;
		spotNumber = n;
		spotSize = sz;
	}
	
	public boolean isAvailable() {
		return vehicle == null;
	}
	
	/* Sprawdza, czy miejsce jest wystarczająco duże dla pojazdu (i czy jest dostępne). Sprawdzana
	 * jest tu tylko wielkość miejsca, a nie liczba miejsc */
	public boolean canFitVehicle(Vehicle vehicle) {
		return isAvailable() && vehicle.canFitInSpot(this);
	}
	
	/* Parkowanie pojazdu w danym miejscu */
	public boolean park(Vehicle v) {
		if (!canFitVehicle(v)) {
			return false;
		}
		vehicle = v;
		vehicle.parkInSpot(this);
		return true;
	}
	
	public int getRow() {
		return row;
	}
	
	public int getSpotNumber() {
		return spotNumber;
	}
	
	public VehicleSize getSize() {
		return spotSize;
	}
	
	/* Zwalnianie miejsca przez pojazd i powiadamianie poziomu, że dostępne jest nowe miejsce */
	public void removeVehicle() {
		level.spotFreed();
		vehicle = null;
	}
	
	public void print() {
		if (vehicle == null) {
			if (spotSize == VehicleSize.Compact) {
				System.out.print("c");
			} else if (spotSize == VehicleSize.Large) {
				System.out.print("l");
			} else if (spotSize == VehicleSize.Motorcycle) {
				System.out.print("m");
			}
		} else {
			vehicle.print();
		}
	}
}
